% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_active.R
\name{tar_active}
\alias{tar_active}
\title{Show if the pipeline is running.}
\usage{
tar_active()
}
\value{
Logical of length 1, \code{TRUE} if called in a target or \verb{_targets.R}
and the pipeline is running (\code{FALSE} otherwise).
}
\description{
Return \code{TRUE} if called in a target or \verb{_targets.R} and
the pipeline is running.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_active() # FALSE
tar_script({
  message("Pipeline running? ", tar_active())
  tar_target(x, tar_active())
})
tar_manifest() # prints "Pipeline running? FALSE"
tar_make() # prints "pipeline running? TRUE"
tar_read(x) # TRUE
})
}
}
\seealso{
Other utilities: 
\code{\link{tar_backoff}()},
\code{\link{tar_call}()},
\code{\link{tar_cancel}()},
\code{\link{tar_definition}()},
\code{\link{tar_described_as}()},
\code{\link{tar_envir}()},
\code{\link{tar_group}()},
\code{\link{tar_name}()},
\code{\link{tar_path}()},
\code{\link{tar_path_script}()},
\code{\link{tar_path_script_support}()},
\code{\link{tar_path_store}()},
\code{\link{tar_path_target}()},
\code{\link{tar_source}()},
\code{\link{tar_store}()}
}
\concept{utilities}
