% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_meta_sync.R
\name{tar_meta_sync}
\alias{tar_meta_sync}
\title{Synchronize cloud metadata.}
\usage{
tar_meta_sync(
  prefer_local = TRUE,
  verbose = TRUE,
  script = targets::tar_config_get("script"),
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{prefer_local}{Logical of length 1 to control which copy of each
metadata file takes precedence if the local hash and cloud hash
are different but the time stamps are the same. Set to \code{TRUE}
to upload the local data file in that scenario, \code{FALSE} to download
the cloud file.}

\item{verbose}{Logical of length 1, whether to print informative
console messages.}

\item{script}{Character of length 1, path to the
target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}. When you set
this argument, the value of \code{tar_config_get("script")}
is temporarily changed for the current function call.
See \code{\link[=tar_script]{tar_script()}},
\code{\link[=tar_config_get]{tar_config_get()}}, and \code{\link[=tar_config_set]{tar_config_set()}} for details
about the target script file and how to set it
persistently for a project.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\description{
Synchronize metadata in a cloud bucket with metadata in the
local data store.
}
\details{
\code{\link[=tar_meta_sync]{tar_meta_sync()}} synchronizes the local and cloud copies
of all the metadata files of the pipeline so that both have the
most recent copy. For each metadata file,
if the local file does not exist or is older than the cloud file,
then the cloud file is downloaded to the local file path.
Conversely, if the cloud file is older or does not exist, then the local
file is uploaded to the cloud. If the time stamps of these files are
equal, use the \code{prefer_local} argument to determine
which copy takes precedence.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
}, ask = FALSE)
tar_make()
tar_meta_sync()
})
}
}
\seealso{
Other metadata: 
\code{\link{tar_meta_delete}()},
\code{\link{tar_meta_download}()},
\code{\link{tar_meta_upload}()},
\code{\link{tar_meta}()}
}
\concept{metadata}
