% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_option_reset.R
\name{tar_option_reset}
\alias{tar_option_reset}
\title{Reset all target options.}
\usage{
tar_option_reset()
}
\value{
\code{NULL} (invisibly).
}
\description{
Reset all target options you previously chose with
\code{\link[=tar_option_set]{tar_option_set()}}. These options are mostly configurable default
arguments to \code{\link[=tar_target]{tar_target()}} and \code{\link[=tar_target_raw]{tar_target_raw()}}.
}
\examples{
tar_option_get("format") # default format before we set anything
tar_target(x, 1)$settings$format
tar_option_set(format = "fst_tbl") # new default format
tar_option_get("format")
tar_target(x, 1)$settings$format
tar_option_reset() # reset all options
tar_target(x, 1)$settings$format
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  tar_option_set(cue = tar_cue(mode = "always"))
  tar_option_reset() # Undo option above.
  list(tar_target(x, 1), tar_target(y, 2))
})
tar_make()
tar_make()
})
}
}
\seealso{
Other configuration: 
\code{\link{tar_config_get}()},
\code{\link{tar_config_set}()},
\code{\link{tar_envvars}()},
\code{\link{tar_option_get}()},
\code{\link{tar_option_set}()}
}
\concept{configuration}
