% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_read_raw.R
\name{tar_read_raw}
\alias{tar_read_raw}
\title{Read a target's value from storage (raw version)}
\usage{
tar_read_raw(name, branches = NULL, meta = tar_meta())
}
\arguments{
\item{name}{Character, name of the target to read.}

\item{branches}{Integer of indices of the branches to load
if the target is a pattern.}

\item{meta}{Data frame of metadata from \code{\link[=tar_meta]{tar_meta()}}.
\code{tar_read()} with the default arguments can be inefficient for large
pipelines because all the metadata is stored in a single file.
However, if you call \code{\link[=tar_meta]{tar_meta()}} beforehand and supply it to the \code{meta}
argument, then successive calls to \code{tar_read()} may run much faster.}
}
\value{
The target's return value from its file in
\verb{_targets/objects/}, or the paths to the custom files and directories
if \code{format = "file"} was set.
}
\description{
Like \code{\link[=tar_read]{tar_read()}} except \code{name} is a character string.
Do not use in \code{knitr} or R Markdown reports with \code{tarchetypes::tar_knit()}
or \code{tarchetypes::tar_render()}.
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script(list(tar_target(x, 1 + 1)), ask = FALSE)
tar_make()
tar_read_raw("x")
})
}
}
\seealso{
Other data: 
\code{\link{tar_load_raw}()},
\code{\link{tar_load}()},
\code{\link{tar_meta}()},
\code{\link{tar_objects}()},
\code{\link{tar_pid}()},
\code{\link{tar_process}()},
\code{\link{tar_read}()}
}
\concept{data}
