% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_poll.R
\name{tar_poll}
\alias{tar_poll}
\title{Repeatedly poll progress in the R console.}
\usage{
tar_poll(
  interval = 1,
  timeout = Inf,
  fields = c("started", "built", "errored", "canceled", "since")
)
}
\arguments{
\item{interval}{Number of seconds to wait between iterations
of polling progress.}

\item{timeout}{How many seconds to run before exiting.}

\item{fields}{Optional, names of progress data columns to read.
Set to \code{NULL} to read all fields.}
}
\description{
Print the information in \code{\link[=tar_progress_summary]{tar_progress_summary()}}
at regular intervals.
}
\examples{
if (identical(Sys.getenv("TAR_INTERACTIVE_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  list(
    tar_target(x, seq_len(100)),
    tar_target(y, Sys.sleep(0.1), pattern = map(x))
  )
}, ask = FALSE)
px <- tar_make(callr_function = callr::r_bg, reporter = "silent")
tar_poll()
})
}
}
\seealso{
Other progress: 
\code{\link{tar_progress_branches}()},
\code{\link{tar_progress_summary}()},
\code{\link{tar_progress}()},
\code{\link{tar_watch_server}()},
\code{\link{tar_watch_ui}()},
\code{\link{tar_watch}()}
}
\concept{progress}
