% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_reprex.R
\name{tar_reprex}
\alias{tar_reprex}
\title{Reproducible example of \code{targets} with \code{reprex}}
\usage{
tar_reprex(pipeline = tar_target(example_target, 1), run = tar_make(), ...)
}
\arguments{
\item{pipeline}{R code for the target script file \verb{_targets.R}.
\code{library(targets)} is automatically written at the top.}

\item{run}{R code to inspect and run the pipeline.}

\item{...}{Named arguments passed to \code{reprex::reprex()}.}
}
\value{
A character vector of rendered the reprex, invisibly.
}
\description{
Create a reproducible example of a \code{targets}
pipeline with the \code{reprex} package.
}
\details{
The best way to get help with an issue is to
create a reproducible example of the problem
and post it to \url{https://github.com/ropensci/targets/discussions}
\code{tar_reprex()} facilitates this process. It is like
\code{reprex::reprex({targets::tar_script(...); tar_make()})},
but more convenient.
}
\examples{
if (identical(Sys.getenv("TAR_INTERACTIVE_EXAMPLES"), "true")) {
tar_reprex(
  pipeline = {
    list(
      tar_target(data, data.frame(x = sample.int(1e3))),
      tar_target(summary, mean(data$x, na.rm = TRUE))
    )
  },
  run = {
    tar_visnetwork()
    tar_make()
  }
)
}
}
\seealso{
Other help: 
\code{\link{targets-package}},
\code{\link{use_targets_rmd}()},
\code{\link{use_targets}()}
}
\concept{help}
