% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_callr.R
\name{tar_callr_inner_try}
\alias{tar_callr_inner_try}
\title{Invoke a \code{targets} task from inside a \code{callr} function.}
\usage{
tar_callr_inner_try(
  targets_function,
  targets_arguments,
  options,
  envir = NULL,
  parent,
  script,
  store,
  fun
)
}
\arguments{
\item{targets_function}{A function from \code{targets} to call.}

\item{targets_arguments}{Named list of arguments of targets_function.}

\item{options}{Names of global options to temporarily set
in the \code{callr} process.}

\item{envir}{Name of the environment to run in. If \code{NULL},
the environment defaults to \code{tar_option_get("envir")}.}

\item{parent}{Parent environment of the call to
\code{tar_call_inner()}.}

\item{script}{Character of length 1, path to the
target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}. When you set
this argument, the value of \code{tar_config_get("script")}
is temporarily changed for the current function call.
See \code{\link[=tar_script]{tar_script()}},
\code{\link[=tar_config_get]{tar_config_get()}}, and \code{\link[=tar_config_set]{tar_config_set()}} for details
about the target script file and how to set it
persistently for a project.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}

\item{fun}{Character of length 1, name of the \code{targets}
function being called.}
}
\value{
The output of a call to a \code{targets} function that uses
\code{callr} for reproducibility.
}
\description{
Not a user-side function. Do not invoke directly.
Exported for internal purposes only.
}
\examples{
# See the examples of tar_make().
}
\keyword{internal}
