% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring.R
\name{scoring}
\alias{scoring}
\title{Predictive model scoring}
\usage{
scoring(
  response,
  ...,
  type = "quantitative",
  levels = NULL,
  metrics = NULL,
  weights = NULL,
  names = NULL,
  object = NULL,
  newdata = NULL,
  messages = 1
)
}
\arguments{
\item{response}{Observed response}

\item{...}{model predictions (continuous predictions or class probabilities
(matrices))}

\item{type}{continuous or categorical response (the latter is automatically
chosen if response is a factor, otherwise a continuous response is assumed)}

\item{levels}{(optional) unique levels in response variable}

\item{metrics}{which metrics to report}

\item{weights}{optional frequency weights}

\item{names}{(optional) character vector of the model names in the output. If
omitted these will be taken from the names of the ellipsis argument (...)}

\item{object}{optional model object}

\item{newdata}{(optional) data.frame on which to evaluate the model
performance}

\item{messages}{controls amount of messages/warnings (0: none)}
}
\value{
Numeric matrix of dimension m x p, where m is the number of
different models and p is the number of model metrics
}
\description{
Predictive model scoring
}
\examples{
data(iris)
set.seed(1)
dat <- lava::csplit(iris,2)
g1 <- naivebayes(Species ~ Sepal.Width + Petal.Length, data=dat[[1]])
g2 <- naivebayes(Species ~ Sepal.Width, data=dat[[1]])
pr1 <- predict(g1, newdata=dat[[2]], wide=TRUE)
pr2 <- predict(g2, newdata=dat[[2]], wide=TRUE)
table(colnames(pr1)[apply(pr1,1,which.max)], dat[[2]]$Species)
table(colnames(pr2)[apply(pr2,1,which.max)], dat[[2]]$Species)
scoring(dat[[2]]$Species, pr1=pr1, pr2=pr2)
## quantitative response:
scoring(response=1:10, prediction=rnorm(1:10))
}
