% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_quarto_files.R
\name{tar_quarto_files}
\alias{tar_quarto_files}
\title{Quarto file detection}
\usage{
tar_quarto_files(path = ".")
}
\arguments{
\item{path}{Character of length 1, either the file path
to a Quarto source document or the directory path
to a Quarto project. Defaults to the Quarto project in the
current working directory.}
}
\value{
A named list of important file paths in a Quarto project or document:
\itemize{
\item \code{sources}: source files with \code{tar_load()}/\code{tar_read()}
target dependencies in R code chunks.
\item \code{output}: output files that will be generated during
\code{quarto::quarto_render()}.
\item \code{input}: pre-existing files required to render the project or document,
such as \verb{_quarto.yml}.
}
}
\description{
Detect the important files in a Quarto project.
}
\details{
This function is just a thin wrapper that interprets the output
of \code{quarto::quarto_inspect()} and returns what \code{tarchetypes} needs to
know about the current Quarto project or document.
}
\examples{
lines <- c(
  "---",
  "title: source file",
  "---",
  "Assume these lines are in report.qmd.",
  "```{r}",
  "1 + 1",
  "```"
)
path <- tempfile(fileext = ".qmd")
writeLines(lines, path)
# If Quarto is installed, run:
# tar_quarto_files(path)
}
\seealso{
Other Literate programming utilities: 
\code{\link{tar_knitr_deps_expr}()},
\code{\link{tar_knitr_deps}()}
}
\concept{Literate programming utilities}
