% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_tracks.R
\name{fit_tracks}
\alias{fit_tracks}
\title{Integrate track with reference positions}
\usage{
fit_tracks(P, times = NULL, D, sampling_rate)
}
\arguments{
\item{P}{a two column matrix or data frame containing the anchor positions. The first column should be the "northing" and the second the "easting" coordinates. (If data frame is input, then columns with those two names, in any position, will be used if present).}

\item{times}{a vector of times corresponding to the positions P. If P is a data frame with a column called "times" then that column will be used.
Times are in seconds since the start of the regularly sampled track.
times must have the same number of rows as P. Times
must be greater than or equal to 0 and less than the time length of the regularly sampled track.}

\item{D}{a two column matrix containing the regularly sampled track
points. If D is a data frame with columns named 'northing' and 'easting' those will be used regardless of position; otherwise the first column will be northing and the second easting. The two columns contain the 'x' and 'y' coordinates of the
track points in a local level frame. Units, axes and frame must match those of P.}

\item{sampling_rate}{is the sampling rate in Hz of D.}
}
\value{
D, a data frame with 4 columns: "northing" and "easting" along the new track,
and "current_n" and "current_e", the track increments needed to match the tracks.
If the difference between the two tracks is due to the medium moving,
these increments can be considered an estimate of the current in m/s.
The axes and frame are the same as for the input data.
}
\description{
Simple track integration method to merge infrequent
but accurate positions with a regularly sampled track
that is not absolutely accurate.
}
