% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tadaa_two_sample.R
\name{tadaa_z.test}
\alias{tadaa_z.test}
\title{Tadaa, z-test! No seriously.}
\usage{
tadaa_z.test(
  data,
  x,
  y,
  sigma_x,
  sigma_y,
  direction = "two.sided",
  paired = FALSE,
  conf.level = 0.95,
  print = c("df", "console", "html", "markdown")
)
}
\arguments{
\item{data}{A \code{data.frame} containing variables.}

\item{x, y}{A bare name of a numeric variable in \code{data}.}

\item{sigma_x, sigma_y}{Numeric. Known variances of \code{x} and \code{y}.}

\item{direction}{Test direction, like \code{alternative} in \link{t.test}.}

\item{paired}{If \code{TRUE}, a paired test is performed, defaults to \code{FALSE}.}

\item{conf.level}{Confidence level used for power and CI, default is \code{0.95}.}

\item{print}{Print method, default \code{df}: A regular \code{data.frame}.
Otherwise passed to \link[pixiedust:sprinkle_print_method]{pixiedust::sprinkle_print_method} for fancyness.}
}
\value{
A \link[pixiedust:dust]{pixiedust::dust} object or \code{data.frame}.
}
\description{
This is a wrapper around \link{z.test}, which in itself is a weird thing to use, but
why not.
}
\examples{
set.seed(192)
df <- data.frame(
  lefties = rnorm(10, mean = 5, sd = 2),
  righties = rnorm(10, mean = 5.5, sd = 2.5)
)
tadaa_z.test(data = df, x = lefties, y = righties, sigma_x = 2, sigma_y = 2.5, print = "console")
}
