% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutoff.R
\name{cutoff_aiz}
\alias{cutoff_aiz}
\title{Cutoff value calculation using method described in Aizenstein et al. 2008}
\usage{
cutoff_aiz(modelstats, ROIs)
}
\arguments{
\item{modelstats}{SUVR or DVR data for group of participants from batch_tm()}

\item{ROIs}{list of variables (ROIs) to use for cutoff detection}
}
\value{
Cutoff values for each ROI based on the above method
}
\description{
See the reference below and the tacmagic walkthrough vignette. Aizenstein et
al. (2008) proposed a standardized method of calculating Pittsburgh Compound
B (PIB) cutoff values to classify participants as PIB+ or PIB-. They used the
distribution volume ratio (DVR) from several ROIs associated with amyloid 
deposition. The steps are summarized below. cutoff_aiz() implements 1-3,
returning cutoff values for each ROI. It can be used to dichotomize
participants, with pos_anyroi().
}
\details{
1. Remove outliers from a group of cognitively normal individuals. An outlier
is defined as having any ROI with DVR > upper inner fence of that ROI (= 3rd
quartile + (1.5 * IQR).
2. Iterate step 1 as needed until there are no more outlying participants.
3. From this subset of the group with outliers removed, the cutoff value for 
each ROI is set as the upper inner fence. 
4. For all participants, if there is any ROI above the cutoff for that 
region, then the participant is deemed to be PIB+.
}
\examples{
cutoff_aiz(fake_DVR, c("ROI1_DVR", "ROI2_DVR", "ROI3_DVR", "ROI4_DVR"))
}
\references{
Aizenstein HJ, Nebes RD, Saxton JA, et al. 2008. Frequent amyloid 
deposition without significant cognitive impairment among the elderly. 
Arch Neurol 65: 1509-1517.
}
\seealso{
Other Cutoff functions: \code{\link{pos_anyroi}}
}
\concept{Cutoff functions}
