/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snap;

import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.snap.SnappingPointIndex;

public class SnappingIntersectionAdder
implements SegmentIntersector {
    private LineIntersector li = new RobustLineIntersector();
    private double snapTolerance;
    private SnappingPointIndex snapPointIndex;

    public SnappingIntersectionAdder(double snapTolerance, SnappingPointIndex snapPointIndex) {
        this.snapPointIndex = snapPointIndex;
        this.snapTolerance = snapTolerance;
    }

    @Override
    public void processIntersections(SegmentString seg0, int segIndex0, SegmentString seg1, int segIndex1) {
        if (seg0 == seg1 && segIndex0 == segIndex1) {
            return;
        }
        Coordinate p00 = seg0.getCoordinates()[segIndex0];
        Coordinate p01 = seg0.getCoordinates()[segIndex0 + 1];
        Coordinate p10 = seg1.getCoordinates()[segIndex1];
        Coordinate p11 = seg1.getCoordinates()[segIndex1 + 1];
        if (!SnappingIntersectionAdder.isAdjacent(seg0, segIndex0, seg1, segIndex1)) {
            this.li.computeIntersection(p00, p01, p10, p11);
            if (this.li.hasIntersection() && this.li.getIntersectionNum() == 1) {
                Coordinate intPt = this.li.getIntersection(0);
                Coordinate snapPt = this.snapPointIndex.snap(intPt);
                ((NodedSegmentString)seg0).addIntersection(snapPt, segIndex0);
                ((NodedSegmentString)seg1).addIntersection(snapPt, segIndex1);
            }
        }
        this.processNearVertex(seg0, segIndex0, p00, seg1, segIndex1, p10, p11);
        this.processNearVertex(seg0, segIndex0, p01, seg1, segIndex1, p10, p11);
        this.processNearVertex(seg1, segIndex1, p10, seg0, segIndex0, p00, p01);
        this.processNearVertex(seg1, segIndex1, p11, seg0, segIndex0, p00, p01);
    }

    private void processNearVertex(SegmentString srcSS, int srcIndex, Coordinate p, SegmentString ss, int segIndex, Coordinate p0, Coordinate p1) {
        if (p.distance(p0) < this.snapTolerance) {
            return;
        }
        if (p.distance(p1) < this.snapTolerance) {
            return;
        }
        double distSeg = Distance.pointToSegment(p, p0, p1);
        if (distSeg < this.snapTolerance) {
            ((NodedSegmentString)ss).addIntersection(p, segIndex);
            ((NodedSegmentString)srcSS).addIntersection(p, srcIndex);
        }
    }

    private static boolean isAdjacent(SegmentString ss0, int segIndex0, SegmentString ss1, int segIndex1) {
        boolean isAdjacent;
        if (ss0 != ss1) {
            return false;
        }
        boolean bl = isAdjacent = Math.abs(segIndex0 - segIndex1) == 1;
        if (isAdjacent) {
            return true;
        }
        if (ss0.isClosed()) {
            int maxSegIndex = ss0.size() - 1;
            if (segIndex0 == 0 && segIndex1 == maxSegIndex || segIndex1 == 0 && segIndex0 == maxSegIndex) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDone() {
        return false;
    }
}

