% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/index_diversity.R
\docType{methods}
\name{jackknife_diversity}
\alias{jackknife_diversity}
\alias{jackknife,DiversityIndex-method}
\title{Jackknife Estimation}
\usage{
\S4method{jackknife}{DiversityIndex}(object, f = NULL)
}
\arguments{
\item{object}{An \R object (typically a \linkS4class{DiversityIndex} object).}

\item{f}{A \code{\link{function}} that takes a single numeric vector (the leave-one-out
values of \code{do}) as argument.}
}
\value{
If \code{f} is \code{NULL} (the default), \code{jackknife()} returns a named \code{numeric}
vector with the following elements:
\describe{
\item{\code{original}}{The observed value of \code{do} applied to \code{object}.}
\item{\code{mean}}{The jackknife estimate of mean of \code{do}.}
\item{\code{bias}}{The jackknife estimate of bias of \code{do}.}
\item{\code{error}}{he jackknife estimate of standard error of \code{do}.}
}

If \code{f} is a \code{function}, \code{jackknife()} returns the result of \code{f} applied to
the leave-one-out values of \code{do}.
}
\description{
Jackknife Estimation
}
\examples{
## Data from Conkey 1980, Kintigh 1989
data("cantabria")

## Shannon diversity index
(h <- heterogeneity(cantabria, method = "shannon"))

## Bootstrap resampling
bootstrap(h, f = NULL)

bootstrap(h, f = summary)

quant <- function(x) quantile(x, probs = c(0.25, 0.50))
bootstrap(h, f = quant)

## Jackknife resampling
jackknife(h)

bootstrap(h, f = summary)
}
\seealso{
Other resampling methods: 
\code{\link{bootstrap_diversity}},
\code{\link{resample}()}
}
\author{
N. Frerebeau
}
\concept{resampling methods}
