% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_rank.R
\docType{methods}
\name{plot_line}
\alias{plot_line}
\alias{plot_rank}
\alias{plot_rank-method}
\alias{plot_rank,matrix-method}
\alias{plot_rank,data.frame-method}
\title{Line Plot}
\usage{
plot_rank(object, ...)

\S4method{plot_rank}{matrix}(object, log = NULL, facet = FALSE)

\S4method{plot_rank}{data.frame}(object, log = NULL, facet = FALSE)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each class).}

\item{...}{Further arguments to be passed to internal methods.}

\item{log}{A \code{\link{character}} string which contains "\code{x}" if the x axis is to be
logarithmic, "\code{y}" if the y axis is to be logarithmic and "\code{xy}" or "\code{yx}"
if both axes are to be logarithmic (base 10).}

\item{facet}{A \code{\link{logical}} scalar: should a matrix of panels defined by
case/sample be drawn?}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
Plots a rank \emph{vs} relative abundance diagram.
}
\examples{
## Abundance matrix
## Coerce datasets to a count matrix (data from Desachy 2004)
data("compiegne", package = "folio")

## Plot rank vs abundance
plot_rank(compiegne)
plot_rank(compiegne, facet = TRUE)
}
\references{
Magurran, A. E. (1988). \emph{Ecological Diversity and its Measurement}.
Princeton, NJ: Princeton University Press. \doi{10.1007/978-94-015-7358-0}.
}
\seealso{
Other plot methods: 
\code{\link{plot_bar}},
\code{\link{plot_diversity}},
\code{\link{plot_heatmap}()},
\code{\link{plot_spot}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
