% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/index_heterogeneity.R
\docType{methods}
\name{heterogeneity}
\alias{heterogeneity}
\alias{heterogeneity-method}
\alias{evenness}
\alias{evenness-method}
\alias{index_berger}
\alias{index_berger-method}
\alias{index_brillouin}
\alias{index_brillouin-method}
\alias{index_mcintosh}
\alias{index_mcintosh-method}
\alias{index_shannon}
\alias{index_shannon-method}
\alias{index_simpson}
\alias{index_simpson-method}
\alias{heterogeneity,matrix-method}
\alias{heterogeneity,data.frame-method}
\alias{evenness,matrix-method}
\alias{evenness,data.frame-method}
\alias{index_berger,numeric-method}
\alias{index_brillouin,numeric-method}
\alias{index_mcintosh,numeric-method}
\alias{index_shannon,numeric-method}
\alias{index_simpson,numeric-method}
\title{Heterogeneity and Evenness}
\usage{
heterogeneity(object, ...)

evenness(object, ...)

index_berger(x, ...)

index_brillouin(x, ...)

index_mcintosh(x, ...)

index_shannon(x, ...)

index_simpson(x, ...)

\S4method{heterogeneity}{matrix}(
  object,
  method = c("berger", "brillouin", "mcintosh", "shannon", "simpson")
)

\S4method{heterogeneity}{data.frame}(
  object,
  method = c("berger", "brillouin", "mcintosh", "shannon", "simpson")
)

\S4method{evenness}{matrix}(object, method = c("shannon", "brillouin", "mcintosh", "simpson"))

\S4method{evenness}{data.frame}(object, method = c("shannon", "brillouin", "mcintosh", "simpson"))

\S4method{index_berger}{numeric}(x, na.rm = FALSE, ...)

\S4method{index_brillouin}{numeric}(x, evenness = FALSE, na.rm = FALSE, ...)

\S4method{index_mcintosh}{numeric}(x, evenness = FALSE, na.rm = FALSE, ...)

\S4method{index_shannon}{numeric}(x, evenness = FALSE, base = exp(1), na.rm = FALSE, ...)

\S4method{index_simpson}{numeric}(x, evenness = FALSE, na.rm = FALSE, ...)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each class).}

\item{...}{Currently not used.}

\item{x}{A \code{\link{numeric}} vector of count data (absolute frequencies).}

\item{method}{A \code{\link{character}} string specifying the index to be computed
(see details). Any unambiguous substring can be given.}

\item{na.rm}{A \code{\link{numeric}} scalar: should missing values (including \code{NaN}) be
removed?}

\item{evenness}{A \code{\link{logical}} scalar: should an evenness measure be computed
instead of an heterogeneity/dominance index?}

\item{base}{A positive \code{\link{numeric}} value specifying the base with respect to
which logarithms are computed.}
}
\value{
\itemize{
\item \code{heterogeneity()} returns an \linkS4class{HeterogeneityIndex} object.
\item \code{evenness()} returns an \linkS4class{EvennessIndex} object.
\item \verb{index_*()} return a \code{\link{numeric}} vector.
}
}
\description{
\itemize{
\item \code{heterogeneity()} returns an heterogeneity or dominance index.
\item \code{evenness()} returns an evenness measure.
}
}
\details{
\emph{Diversity} measurement assumes that all individuals in a specific
taxa are equivalent and that all types are equally different from each
other (Peet 1974). A measure of diversity can be achieved by using indices
built on the relative abundance of taxa. These indices (sometimes referred
to as non-parametric indices) benefit from not making assumptions about the
underlying distribution of taxa abundance: they only take relative
abundances of the species that are present and species richness into
account. Peet (1974) refers to them as indices of \emph{heterogeneity}.

Diversity indices focus on one aspect of the taxa abundance and emphasize
either \emph{richness} (weighting towards uncommon taxa) or dominance (weighting
towards abundant taxa; Magurran 1988).

\emph{Evenness} is a measure of how evenly individuals are distributed across the
sample.
}
\note{
Ramanujan approximation is used for \eqn{x!} computation if \eqn{x > 170}.
}
\section{Heterogeneity and Evenness Measures}{

The following heterogeneity index and corresponding evenness measures
are available (see Magurran 1988 for details):
\describe{
\item{\code{berger}}{Berger-Parker dominance index. The Berger-Parker index
expresses the proportional importance of the most abundant type. This
metric is highly biased by sample size and richness, moreover it does not
make use of all the information available from sample.}
\item{\code{brillouin}}{Brillouin diversity index. The Brillouin index describes
a known collection: it does not assume random sampling in an infinite
population. Pielou (1975) and Laxton (1978) argues for the use of the
Brillouin index in all circumstances, especially in preference to the
Shannon index.}
\item{\code{mcintosh}}{McIntosh dominance index. The McIntosh index expresses
the heterogeneity of a sample in geometric terms. It describes the sample
as a point of a \eqn{S}-dimensional hypervolume and uses the Euclidean
distance of this point from the origin.}
\item{\code{shannon}}{Shannon-Wiener diversity index. The Shannon index assumes
that individuals are randomly sampled from an infinite population and that
all taxa are represented in the sample (it does not reflect the
sample size). The main source of error arises from the failure to include
all taxa in the sample: this error increases as the proportion of species
discovered in the sample declines (Peet 1974, Magurran 1988). The
maximum likelihood estimator (MLE) is used for the relative abundance,
this is known to be negatively biased by sample size.}
\item{\code{simpson}}{Simpson dominance index for finite sample. The Simpson
index expresses the probability that two individuals randomly picked from
a finite sample belong to two different types. It can be interpreted as
the weighted mean of the proportional abundances. This metric is a true
probability value, it ranges from \eqn{0} (perfectly uneven) to \eqn{1}
(perfectly even).}
}

The \code{berger}, \code{mcintosh} and \code{simpson} methods return a \emph{dominance} index,
not the reciprocal or inverse form usually adopted, so that an increase in
the value of the index accompanies a decrease in diversity.
}

\examples{
data("chevelon", package = "folio")

## Shannon diversity index
(h <- heterogeneity(chevelon, method = "shannon"))
(e <- evenness(chevelon, method = "shannon"))

## Bootstrap resampling (summary statistics)
bootstrap(h, f = NULL)

bootstrap(h, f = summary)

quant <- function(x) quantile(x, probs = c(0.25, 0.50))
bootstrap(h, f = quant)

## Jackknife resampling
jackknife(h)
}
\references{
Berger, W. H. & Parker, F. L. (1970). Diversity of Planktonic Foraminifera
in Deep-Sea Sediments. \emph{Science}, 168(3937), 1345-1347.
\doi{10.1126/science.168.3937.1345}.

Brillouin, L. (1956). \emph{Science and information theory}. New York:
Academic Press.

Kintigh, K. W. (1989). Sample Size, Significance, and Measures of
Diversity. In Leonard, R. D. and Jones, G. T., \emph{Quantifying Diversity
in Archaeology}. New Directions in Archaeology. Cambridge:
Cambridge University Press, p. 25-36.

Laxton, R. R. (1978). The measure of diversity. \emph{Journal of Theoretical
Biology}, 70(1), 51-67.
\doi{10.1016/0022-5193(78)90302-8}.

Magurran, A. E. (1988). \emph{Ecological Diversity and its Measurement}.
Princeton, NJ: Princeton University Press.
\doi{10.1007/978-94-015-7358-0}.

McIntosh, R. P. (1967). An Index of Diversity and the Relation of Certain
Concepts to Diversity. \emph{Ecology}, 48(3), 392-404.
\doi{10.2307/1932674}.

Peet, R. K. (1974). The Measurement of Species Diversity. \emph{Annual Review of
Ecology and Systematics}, 5(1), 285-307.
\doi{10.1146/annurev.es.05.110174.001441}.

Pielou, E. C. (1975). \emph{Ecological Diversity}. New York: Wiley.
\doi{10.4319/lo.1977.22.1.0174b}

Shannon, C. E. (1948). A Mathematical Theory of Communication. \emph{The
Bell System Technical Journal}, 27, 379-423.
\doi{10.1002/j.1538-7305.1948.tb01338.x}.

Simpson, E. H. (1949). Measurement of Diversity. \emph{Nature}, 163(4148),
688-688. \doi{10.1038/163688a0}.
}
\seealso{
Other diversity measures: 
\code{\link{occurrence}()},
\code{\link{plot_diversity}},
\code{\link{rarefaction}()},
\code{\link{richness}()},
\code{\link{similarity}()},
\code{\link{simulate}()},
\code{\link{turnover}()}
}
\author{
N. Frerebeau
}
\concept{diversity measures}
