% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{import}
\alias{import}
\title{Import a reconstruction as class tabs object}
\usage{
import(filename)
}
\arguments{
\item{filename}{character. Path where outputs of the reconstruct-function were exported. Data exported in the following formats can be imported: directory tree, .qs2 and .rds.}
}
\value{
object of class tabs including a list of input (topo, labs, curve, correction) and output (recvect, recrast, recarea) datasets
}
\description{
import TABS object
}
\examples{

# load data samples
sporades <- sporades()
topo <- sporades$topo
labs <- sporades$labs
correction <- sporades$correction
curve <- sporades$curve

# subset first and last period 
curve <- curve[[c(1,dim(curve)[3])]]

# reconstruct
rec <- reconstruct(topo=topo,
                   region=labs,
                   curve=curve,
                   correction=correction,
                   reclabs='name'
                   )

# metadata
md <- metadata(rec)
                   
\donttest{                   
# export     
dir <- tempdir() # export to temporary directory 
export(rec, paste0(dir,'/sporades.qs2'),overwrite=TRUE) # qs2 (faster and less storage than rds) 
export(rec, paste0(dir,'/sporades.rds'), overwrite=TRUE) # rds / rdata 
export(rec, paste0(dir,'/sporades'), overwrite=TRUE)  # datasets organized in directory  
#export(rec, paste0(dir,'/sporades.zip')) # zipped datasets 
}            
\donttest{                   
# import
rec <- import(filename=paste0(dir,'/sporades.qs2'))
rec <- import(filename=paste0(dir,'/sporades.rds'))
rec <- import(filename=paste0(dir,'/sporades'))
}    
# explore 

## tabs class object
if (interactive()){
explore(rec) # comparison present reference and topo-based
explore(rec, timelapse=3) # paleo reconstruction 
}

## from exported object 
if (interactive()){
explore(paste0(dir,'/sporades.qs2'))
explore(paste0(dir,'/sporades.qs2'), timelapse=1)
}

# get area 
area <- get_area(rec) # using object class tabs 
area <- get_area(rec$recvect) # using recvect 
\donttest{
area <- get_area(paste0(dir,'/sporades.qs2')) # using exported object
unlink(dir)
}

}
\author{
Johannes De Groeve
}
