% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/music.R
\name{music-helpers}
\alias{music-helpers}
\alias{music_notes}
\alias{music_info}
\alias{music_strings}
\alias{music_key}
\alias{music_time}
\alias{music_tempo}
\alias{music_lyrics}
\title{Accessing music object values and attributes}
\usage{
music_notes(x)

music_info(x)

music_strings(x)

music_key(x)

music_time(x)

music_tempo(x)

music_lyrics(x)
}
\arguments{
\item{x}{music object.}
}
\value{
depends on the function
}
\description{
Helper functions for accessing music object values and attributes.
}
\details{
Note that while lyrics always shows as an attribute even when \code{NA}, \code{strings}
is completely absent as a value if it was not part of the object construction
from a new character string.
}
\examples{
# Starting string = 5: use ';5'. Carries over until an explicit change.
x <- "a,4;5*5 b,4- c4 cgc'e'~4 cgc'e'1 e'4;2 c';3 g;4 c;5 ce'1;51"
x <- as_music(x)

y <- lyrics_template(x)
y[3:8] <- strsplit("These are some song ly- rics", " ")[[1]]
y

x <- as_music(x, lyrics = y)

attributes(x)

music_split(x)

music_notes(x)
music_info(x)
music_key(x)
music_time(x)
music_tempo(x)
music_lyrics(x)
music_strings(x)
}
\seealso{
\code{\link[=music]{music()}}, \code{\link[=note-checks]{note-checks()}}, \code{\link[=note-metadata]{note-metadata()}}, \code{\link[=note-summaries]{note-summaries()}},
\code{\link[=note-coerce]{note-coerce()}}
}
