% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_methods.R
\name{tabr-length}
\alias{tabr-length}
\alias{length.noteworthy}
\alias{length.noteinfo}
\alias{length.music}
\alias{length.lyrics}
\title{Length for tabr classes}
\usage{
\method{length}{noteworthy}(x)

\method{length}{noteinfo}(x)

\method{length}{music}(x)

\method{length}{lyrics}(x)
}
\arguments{
\item{x}{object.}
}
\description{
Several methods are implemented for the classes \code{noteworthy},
\code{noteinfo}, and \code{music}. See \code{\link{tabr-methods}} for
more details on methods for tabr classes.
}
\examples{
# noteworthy class examples
x <- "a b c"
length(x)
length(as_noteworthy(x))
length(as_noteworthy("a b*2 c*2"))

# noteinfo class examples
x <- "4- t8( t8)( t8) 4*2"
length(x)
length(as_noteinfo(x))

# music class examples
x <- "c,~4 c,1 c'e_'g'4-.*4"
length(x)
length(as_music(x))
}
\seealso{
\code{\link{tabr-methods}}, \code{\link{note-metadata}}
}
