% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals.R
\name{intervals}
\alias{intervals}
\alias{pitch_interval}
\alias{pitch_diff}
\alias{scale_interval}
\alias{scale_diff}
\alias{tuning_intervals}
\title{Interval helpers}
\usage{
pitch_interval(notes1, notes2, use_root = TRUE)

pitch_diff(notes, use_root = TRUE, n = 1, trim = FALSE)

scale_interval(
  notes1,
  notes2,
  use_root = TRUE,
  format = c("mmp_abb", "mmp", "ad_abb", "ad")
)

scale_diff(
  notes,
  use_root = TRUE,
  n = 1,
  trim = FALSE,
  format = c("mmp_abb", "mmp", "ad_abb", "ad")
)

tuning_intervals(tuning = "standard")
}
\arguments{
\item{use_root}{logical, use lowest pitch in chord for pitch intervals or
scale intervals between adjacent timesteps. Otherwise intervals involving
chords are \code{NA}.}

\item{notes, notes1, notes2}{character, a noteworthy string. \code{notes1} and
\code{notes2} must have equal number of timesteps.}

\item{n}{integer, size of lag.}

\item{trim}{logical, trim the \code{n} leading \code{NA} values from lagged
intervals.}

\item{format}{character, format of the scale notation: major/minor/perfect,
augmented/diminished, and respective abbreviations. See argument options in
defaults.}

\item{tuning}{character, string tuning.}
}
\value{
a musical interval, integer or character depending on the function.
}
\description{
Helper functions for musical intervals defined by two notes.
}
\details{
Numeric intervals are directional. \code{pitch_interval} returns the signed
number of semitones defining the distance between two notes.
Named scale intervals are names only. Use pitch for direction.

\code{scale_interval} returns a character string that provides the named
main interval, simple or compound, defined by  the two notes.
This function will return \code{NA} for any uncommon out of range large
interval not listed as a named interval in \code{\link{mainIntervals}}.

\code{pitch_interval} and \code{scale_interval} compute intervals
element-wise between two noteworthy strings. \code{pitch_diff} and
\code{scale_diff} work similarly but compute lagged intervals on the
elements in \code{notes}.
}
\examples{
pitch_interval("b", "c4")
pitch_interval("c, e_, g_, a,", "e_, g_, a, c")
pitch_interval("c r", "dfa d")
pitch_interval("c r", "dfa d", use_root = FALSE)
scale_interval("c", "e_")
scale_interval("ceg", "egd'")

x <- "a, b, c d e f g# ac'e' a c' e'"
pitch_diff(x)
pitch_diff(x, use_root = FALSE)
scale_diff(x)
scale_diff(x, n = 2, trim = TRUE, use_root = FALSE)

# Lagged intervals respect rest timesteps.
# All timestep position including rests are retained.
# But the lag-n difference skips rest entries.
x <- "a, c r r r r g"
pitch_diff(x)
scale_diff(x)
pitch_diff(x, n = 2)
scale_diff(x, n = 2)
pitch_diff(x, n = 2, trim = TRUE)
scale_diff(x, n = 2, trim = TRUE)
}
\seealso{
\code{\link{mainIntervals}}
}
