% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R
\name{tablerCard}
\alias{tablerCard}
\title{Create a Boostrap 4 card}
\usage{
tablerCard(..., title = NULL, options = NULL, footer = NULL,
  status = NULL, statusSide = c("top", "left"), collapsible = TRUE,
  collapsed = FALSE, closable = TRUE, zoomable = TRUE, width = 6,
  overflow = FALSE)
}
\arguments{
\item{...}{Body content}

\item{title}{Card title. If NULL, the header is not displayed.}

\item{options}{Card extra header elements.}

\item{footer}{Card footer. NULL by default. Not displayed if NULL.}

\item{status}{Card status. NULL by default. See \url{https://preview.tabler.io/docs/colors.html} for valid statuses.}

\item{statusSide}{Status side: "top" or "left".}

\item{collapsible}{Whether the card is collapsible. TRUE by default.}

\item{collapsed}{Whether to collapse the card at start. FALSE by default.}

\item{closable}{Whether the card is closable. TRUE by default.}

\item{zoomable}{Whether the card is zoomable. TRUE by default.}

\item{width}{Card width. 6 by default. See Bootstrap grid system. If NULL, the card is
full width.}

\item{overflow}{Whether to set up a x and y overflow. FALSE by default.
Useful in case the card contains large tables.}
}
\description{
Build a tabler card
}
\examples{
if(interactive()){
 library(shiny)
 library(tablerDash)

 shiny::shinyApp(
   ui = tablerDashPage(
    navbar = NULL,
    footer = NULL,
    title = "test",
    body = tablerDashBody(
     tablerCard(
      title = "Card",
      sliderInput("obs", "Number of observations:",
      min = 0, max = 1000, value = 500
      ),
      plotOutput("distPlot"),
      status = "success",
      statusSide = "left"
     )
    )
   ),
   server = function(input, output) {
   output$distPlot <- renderPlot({
    hist(rnorm(input$obs))
   })
  }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
