% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensure_factor.R
\name{ensure_factor}
\alias{ensure_factor}
\title{Ensure Factor Variable in Data Set}
\usage{
ensure_factor(data, execute = FALSE, threshold_factor = 5)
}
\arguments{
\item{data}{A data frame.}

\item{execute}{Bool, default \code{= FALSE}. If TRUE, then output data frame.}

\item{threshold_factor}{An integer, default \code{= 5}. Criteria to judge as factor type. When a variable has more than \code{threshold_factor} unique values, it is considered continuous.}
}
\value{
A list containing data frame and description.
}
\description{
Ensure that factor variables in data set are of the correct type.
}
\examples{
## Load Mayo Clinic Primary Biliary Cirrhosis Data
library(survival)
library(tableeasy)
data(pbc)
## Check variables
head(pbc)
##
ensure_factor(pbc)

ensure_factor(pbc,execute=TRUE)[['message']]
pbc_exe <- ensure_factor(pbc,execute=TRUE)[['data']]
}
