% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtables.R
\name{gtable_legend}
\alias{gtable_legend}
\title{Build a grob containing a legend.}
\usage{
gtable_legend(
  d,
  labels,
  widths,
  heights,
  fg_fun,
  fg_params,
  bg_fun = NULL,
  bg_params = NULL,
  title_x = NULL,
  title_y = NULL,
  title_label = "Title",
  title_gp = gpar(fontsize = 10),
  labels_pad = -1,
  labels_gp = gpar(fontsize = 6),
  padding = 0.3,
  size_unit = "mm",
  name = "legend",
  vp = NULL,
  orientation = c("horizontal", "vertical"),
  ...
)
}
\arguments{
\item{d}{data.frame or matrix}

\item{labels}{tick labels displayed at legend tick marks}

\item{widths}{optional \code{unit.list} specifying the grob widths}

\item{heights}{optional \code{unit.list} specifying the grob heights}

\item{fg_fun}{grob-drawing function}

\item{fg_params}{named list of params passed to fg_fun}

\item{bg_fun}{grob-drawing function}

\item{bg_params}{named list of params passed to bg_fun}

\item{title_x}{\code{unit} specifying the x position of the title}

\item{title_y}{\code{unit} specifying the x position of the title}

\item{title_label}{character vector}

\item{title_gp}{graphical parameters of the title}

\item{labels_pad}{padding between the text labels}

\item{labels_gp}{graphical parameters of the text labels}

\item{padding}{numeric vector specifying the padding between adjacent cells.}

\item{size_unit}{character vector defining the unit used for sizes. See \code{grid::unit} for all possible
specifications}

\item{name}{name of the grob}

\item{vp}{optional viewport}

\item{orientation}{choose 'horizontal' or 'vertical'}

\item{...}{additional parameters passed to \code{add_table_params}.}
}
\value{
A \code{gtable} object.
}
\description{
Build a grob with a legend inside.
}
\author{
Yoann Pradat
}
\keyword{export}
