% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VERBS-group_by.R
\name{group_by-table.express}
\alias{group_by-table.express}
\alias{group_by.ExprBuilder}
\title{Group by clause}
\usage{
\method{group_by}{ExprBuilder}(.data, ...,
  .parse = getOption("table.express.parse", FALSE))
}
\arguments{
\item{.data}{An instance of \link{ExprBuilder}.}

\item{...}{Clause for grouping on columns. The \code{by} inside the \code{data.table}'s frame.}

\item{.parse}{Logical. Whether to apply \code{\link[rlang:parse_expr]{rlang::parse_expr()}} to obtain the expressions.}
}
\description{
Aggregations for a \link[data.table:data.table-class]{data.table::data.table}.
}
\details{
Everything in \code{...} will be wrapped in a call to \code{list}.

To see more examples, check the
\href{https://asardaes.github.io/table.express/articles/table.express.html}{vignette}, or the
\link{table.express-package} entry.
}
\examples{

data("mtcars")

data.table::as.data.table(mtcars) \%>\%
    start_expr \%>\%
    group_by(cyl, gear)

}
