% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VERBS-filter_sd.R
\name{filter_sd}
\alias{filter_sd}
\title{Filter subset of data}
\usage{
filter_sd(.data, .how = Negate(is.na), ..., .SDcols, .collapse = `&`,
  .parse = getOption("table.express.parse", FALSE),
  .chain = getOption("table.express.chain", TRUE))
}
\arguments{
\item{.data}{An instance of \link{ExprBuilder}.}

\item{.how}{The function or function call that will perform the transformation.}

\item{...}{Possibly more arguments for \code{.how}.}

\item{.SDcols}{See \link[data.table:data.table]{data.table::data.table} and the details here.}

\item{.collapse}{See \link{where-table.express}.}

\item{.parse}{Logical. Whether to apply \code{\link[rlang:parse_expr]{rlang::parse_expr()}} to obtain the expressions.}

\item{.chain}{Logical. Should a new frame be automatically chained to the expression if the
clause being set already exists?}
}
\description{
Helper to filter rows with the same condition applied to a subset of the data.
}
\details{
This function adds/chains a \code{where} expression that will be evaluated by
\link[data.table:data.table]{data.table::data.table}. The \code{.how} condition is applied to all specified \code{.SDcols}, and it
supports the \code{.COL} pronoun.

Additionally, \code{.SDcols} supports \link[tidyselect:select_helpers]{tidyselect::select_helpers}, with the caveat that the
expression is evaluated eagerly, i.e. with the currently captured \code{data.table}. Consider using
\code{\link[=chain]{chain()}} to explicitly capture intermediate results as actual \code{data.table}s.

To see more examples, check the
\href{https://asardaes.github.io/table.express/articles/table.express.html}{vignette}, or the
\link{table.express-package} entry.
}
\examples{

data("mtcars")

data.table::as.data.table(mtcars) \%>\%
    start_expr \%>\%
    filter_sd(.COL == 1, .SDcols = c("vs", "am"))

}
