% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPosteriorMode.R
\name{getPosteriorMode}
\alias{getPosteriorMode}
\title{Function to get mode from a posterior distribution}
\usage{
getPosteriorMode(df = NULL, round = 3)
}
\arguments{
\item{df}{data frame, list or vector with posterior distribution(s).}

\item{round}{numeric, number of decimals rounded.}
}
\value{
a vector or a list of modes
}
\description{
This function is a wrapper of \code{\link[hdrcde]{hdr}}, it returns one mode
(if receives a vector), otherwise it returns a list of modes (if receives a
list of vectors). If receives an mcmc object it returns the marginal
parameter mode using Kernel density estimation
(\code{\link[MCMCglmm]{posterior.mode}}).
}
\examples{
# List example
a <- list("First" = rnorm(100,1), "Second" = rnorm(100,2))
getPosteriorMode(a)

# vector example
getPosteriorMode(rnorm(100,5), round = 2)
}
