% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tLagInterimData.R
\name{tLagIntCat}
\alias{tLagIntCat}
\alias{b.data.cat}
\alias{x.data.cat}
\alias{t.data.cat}
\title{Toy Dataset With a Categorical Outcome For Illustration}
\format{
Each dataset provides three data.frames: \code{b.data.cat} containing the
basic observed data on 477 enrolled subjects at the time of an interim
analysis, with columns with headers
\itemize{
\item "subjID" - unique subject identifiers,
\item "u" - minimum of time lag or censoring time,
\item "delta" - time lag/censoring indicator, and
\item "Y" - the outcome if it is available, = 0 if not.
\item "a" - treatment indicator;
}

\code{x.data.cat} contains the baseline covariates for the 477 subjects.
\itemize{
\item "subjID" - unique subject identifiers,
\item "X1" - a continuous covariate;
}

and \code{t.data.cat} contains time-dependent covariate information comprising
\itemize{
\item "subjID" - unique subject identifiers,
\item "lu" - time to leaving hospital, death, or censoring
\item "ldelta" (0), death (1), or left hosp (2)
}
}
\usage{
data(tLagIntCat)
}
\description{
These data are provided for the purposes of illustrating the use of
the software when the outcome of interest is categorical.
Though these data were generated to mimic conditions of a clinical trial,
they should not be interpreted as representing true clinical trial data.
}
\keyword{datasets}
