% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_data-documentation.R
\docType{data}
\name{adjDR}
\alias{adjDR}
\title{Age-adjusted Death Rate by race and gender}
\format{
A \code{data.frame} with 612 observations and 4 variables.
\describe{
 \item{year}{The year for which data was was recorded.}
 \item{race}{The racial group of the deceased One of \code{all} all races; \code{white} 
 whites; \code{black_aa} black / African-American; \code{nat_amer} American Indian
 or Native Alaskan; \code{asian_isl} Asian or Pacific Islander; \code{hisp_lat} Hispanic.}
 \item{gender}{The gender of the deceased. One of \code{c(both, male, female)}}
 \item{adj_death_rate}{The age-adjusted death rate. See details.}
}
}
\source{
\url{http://www.cdc.gov/nchs/nvss/deaths.htm}
}
\usage{
adjDR
}
\description{
A dataset containing age-adjusted death rate data by race and gender of the deceased. Data  
is provided for 1980-2013.
}
\section{Details}{

\itemize{
\item{The age-adjusted death rates are used to compare relative mortality risks among groups and 
over time. They were computed by the direct method, which is defined 
\deqn{R'= \sum_{i} \frac{P_{si}}{P_{s}}R_i} where \eqn{P_{si}} is the standard population for age group i,
\eqn{P_s} is the total US standard population and \eqn{R_i} is the raw death rate for age group i.} 
\item{Populations are based on census counts enumerated as of April 1 of the census year and estimated
as of July 1 for non-census years.}
}
}

\references{
Xu, J. Q., S. L. Murphy, and K. D. Kochanek. "Deaths: final data for 2013." National 
Vital Statistics Reports 64.2 (2015).
}
\keyword{datasets}
