% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_pov_inc.R
\name{pull_pov_inc}
\alias{pull_pov_inc}
\title{Pull ACS income and earnings data}
\usage{
pull_pov_inc(endyear, span, geography)
}
\arguments{
\item{endyear}{An integer, indicating the latest year of the data in the survey.}

\item{span}{An integer in \code{c(1,3,5)} indicating the span of the desired data.}

\item{geography}{a valid \code{geo.set} object specifying the census geography or 
geographies to be fetched.}
}
\value{
A \code{list} containing the endyear, span, a \code{data.frame} of estimates,
a \code{data.frame} of standard errors, a character vector of the original column names,
and a \code{data.frame} of the geography metadata from \code{\link[acs]{acs.fetch}}.
}
\description{
Pull ACS data for a specified geography from base tables
B17001, B17004, B18101, B19001, B19013, B19055, B19057. Not yet 
implemented: B17002
Additional fields, mainly percentages and aggregations, are calculated.
}
\seealso{
\code{\link[acs]{acs.fetch}}, \code{\link[acs]{geo.make}}
}
