% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_race.R
\name{pull_race_data}
\alias{pull_race_data}
\title{Pull ACS race data}
\usage{
pull_race_data(endyear, span, geography)
}
\arguments{
\item{endyear}{An integer, indicating the latest year of the data in the survey.}

\item{span}{An integer in \code{c(1,3,5)} indicating the span of the desired data.}

\item{geography}{a valid \code{geo.set} object specifying the census geography or 
geographies to be fetched.}
}
\value{
A \code{list} containing the endyear, span, a \code{data.frame} of estimates,
a \code{data.frame} of standard errors, and a \code{data.frame} of the geography 
metadata from \code{\link[acs]{acs.fetch}}.
}
\description{
Pull ACS data for a specified geography from base tables
B01001B-I and B02001. ' These tables reference population counts by race.
}
\seealso{
\code{\link[acs]{acs.fetch}}, \code{\link[acs]{geo.make}}
}

