% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_household.R
\name{pull_household}
\alias{pull_household}
\title{Pull ACS}
\usage{
pull_household(endyear, span, geography)
}
\arguments{
\item{endyear}{An integer, indicating the latest year of the data in the survey.}

\item{span}{An integer in \code{c(1,3,5)} indicating the span of the desired data.}

\item{geography}{a valid \code{geo.set} object specifying the census geography or 
geographies to be fetched.}
}
\value{
A \code{list} containing the endyear, span, a \code{data.frame} of estimates,
a \code{data.frame} of standard errors, a character vector of the original column names,
and a \code{data.frame} of the geography metadata from \code{\link[acs]{acs.fetch}}.
}
\description{
Pull ACS data for a specified geography from base tables
B09019, B11011, B19081, B25002, B25003, B25004, B25010, B25024,
B25056, B25058, B25071, and B27001.
Additional fields, mainly percentages and aggregations, are calculated.
}
\seealso{
\code{\link[acs]{acs.fetch}}, \code{\link[acs]{geo.make}}
}

