% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centroid_3d_sq_dist.R
\name{centroid_3d_sq_dist}
\alias{centroid_3d_sq_dist}
\title{Calculate sum of squared 3D point distances from centroid}
\usage{
centroid_3d_sq_dist(point_matrix)
}
\arguments{
\item{point_matrix}{An n-by-3 numerical matrix where each
row corresponds to a single point in 3D space.}
}
\description{
Calculates sum of squared point distances in
3D space betweeen points and their centroid.
\deqn{
\frac{\sum_{i=1}^n (x_i-x_m)^2 + (y_i-y_m)^2 + (z-z_m)^2}
}{
sum_(i=1)^n ((x - x_m)^2 + (y - y_m)^2 + (z - z_m)^2)
}
Where \eqn{X/Y/Z} represent one axis each, \eqn{a_m} represents the mean
of all points' coordinates on an axis, and \eqn{n} represents the total
number of points.
}
\keyword{internal}
