% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_decision.R
\name{pca_decision}
\alias{pca_decision}
\title{PCA decision}
\usage{
pca_decision(smode_data)
}
\arguments{
\item{smode_data}{S-mode dataframe of the reanalysis variable. I.e. output obtained from \code{tidy_cuttime_nc} function.}
}
\value{
a list with: \itemize{
   \item{A list with class \code{princomp} containing all the results of the PCA }
   \item{A data frame containing the main results of the 30 first PCA (standard deviation, proportion of variance and cumulative variance).}
}
}
\description{
\code{pca_decision} plots the explained variances against the number of the principal component. In addition, it returns all the information about the PCA performance.
}
\note{
S-mode PCA require more rows than columns to work. In addition, input data cannot contain NAs.
}
\examples{
# Load data (mslp)
data(mslp)
# Converting our data into a S-mode, but without modifying time period
smode_mslp <- tidy_cuttime_nc(mslp)
# PCA decision performance
info_pca <- pca_decision(smode_mslp$smode_data)

}
\seealso{
\code{\link{tidy_cuttime_nc}}
}
