% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg.fd.R
\name{reg.fd}
\alias{reg.fd}
\title{Sample Regular Functional Data}
\usage{
reg.fd(
  mu = 0,
  X = wiener.process(),
  n = 100,
  m = 51,
  sig = NULL,
  snr = 5,
  domain = c(0, 1),
  grid = seq(domain[1], domain[2], length.out = m)
)
}
\arguments{
\item{mu}{function, scalar or a vector defining the mean function; default value: \code{0}.}

\item{X}{centered stochastic process defined by a function of the form 
\code{X(tObs,n)} and returning \code{n*length(tObs)} matrix, where each row represents observations from a trajectory. Default value: \code{wiener.process()}.}

\item{n}{sample size; default value: \code{100}.}

\item{m}{sampling rate; ignored if \code{grid} is specified; default value: \code{51}.}

\item{sig}{standard deviation of measurement errors; if \code{NULL} then determined by \code{snr}.}

\item{snr}{signal to noise ratio to determine \code{sig}; default value: \code{5}.}

\item{domain}{the domain; default value: \code{c(0,1)}.}

\item{grid}{vector of design points; default value: \code{NULL}.}
}
\value{
a list with the following members 
     \describe{
         \item{\code{t}}{a vector of design points sorted in increasing order.}
         \item{\code{y}}{\code{n*m} matrix; each row represents observations from a trajectory.}
     }
 and with attributes \code{sig}, \code{snr}, \code{domain}, \code{grid} and 
     \describe{
         \item{y0}{\code{n*m} matrix of observations without measurement errors.}
     }
}
\description{
Sample Regular Functional Data
}
\examples{
Y <- reg.fd()
Y <- reg.fd(mu=1, X=gaussian.process(), n=10, m=20)
Y <- reg.fd(mu=cos, X=kl.process(),n=100, m=20)
Y <- reg.fd(mu=cos, X=kl.process(distribution='EXPONENTIAL'),n=100, m=20)
}
