/*
 * Decompiled with CFR 0.152.
 */
package sample;

import dag.Dag;
import java.util.Arrays;
import sample.TrioNodes;
import vcf.BasicGL;
import vcf.GL;

public class TrioBaumLevel {
    private static final int INITIAL_CAPACITY = 400;
    private static final double MIN_VALUE = 4.94E-322;
    private final Dag dag;
    private final GL gl;
    private int marker = -1;
    private int sampleA = -1;
    private int sampleB = -1;
    private int sampleC = -1;
    private int size = 0;
    private int capacity = 400;
    private int[] edgesA1 = new int[400];
    private int[] edgesA2 = new int[400];
    private int[] edgesB1 = new int[400];
    private int[] edgesB2 = new int[400];
    private double[] fwdValues = new double[400];
    private double[] bwdValues = new double[400];
    private double fwdValueSum = 0.0;
    private double bwdValueSum = 0.0;
    private int nGenotypes = 0;
    private double[] gtProbsA = new double[3];
    private double[] gtProbsB = new double[3];
    private double[] gtProbsC = new double[3];

    public TrioBaumLevel(Dag dag, GL gL) {
        if (!dag.markers().equals(gL.markers())) {
            throw new IllegalArgumentException("marker inconsistency");
        }
        this.dag = dag;
        this.gl = gL;
    }

    public static void initializeNodes(TrioNodes trioNodes) {
        trioNodes.clear();
        trioNodes.sumUpdate(0, 0, 0, 0, 1.0);
    }

    public void setForwardValues(TrioNodes trioNodes, int n, int n2, int n3, int n4) {
        this.marker = n;
        this.sampleA = n2;
        this.sampleB = n3;
        this.sampleC = n4;
        this.nGenotypes = this.gl.marker(n).nGenotypes();
        this.size = 0;
        this.fwdValueSum = 0.0;
        this.bwdValueSum = 0.0;
        this.initializeGtProbs();
        this.setStates(trioNodes);
        this.setChildNodes(trioNodes);
    }

    private void initializeGtProbs() {
        if (this.gtProbsA.length < this.nGenotypes) {
            int n = Math.max(this.nGenotypes, 3 * this.gtProbsA.length / 2 + 1);
            this.gtProbsA = new double[n];
            this.gtProbsB = new double[n];
            this.gtProbsC = new double[n];
        } else {
            for (int i = 0; i < this.nGenotypes; ++i) {
                this.gtProbsA[i] = 0.0;
                this.gtProbsB[i] = 0.0;
                this.gtProbsC[i] = 0.0;
            }
        }
    }

    private void setStates(TrioNodes trioNodes) {
        int n;
        double d = 0.0;
        int n2 = trioNodes.size();
        for (n = 0; n < n2; ++n) {
            int n3 = trioNodes.enumNodeA1(n);
            int n4 = trioNodes.enumNodeA2(n);
            int n5 = trioNodes.enumNodeB1(n);
            int n6 = trioNodes.enumNodeB2(n);
            double d2 = trioNodes.enumValue(n);
            int n7 = this.dag.nOutEdges(this.marker, n3);
            for (int i = 0; i < n7; ++i) {
                int n8 = this.dag.outEdge(this.marker, n3, i);
                byte by = this.dag.symbol(this.marker, n8);
                int n9 = this.dag.nOutEdges(this.marker, n4);
                for (int j = 0; j < n9; ++j) {
                    int n10 = this.dag.outEdge(this.marker, n4, j);
                    byte by2 = this.dag.symbol(this.marker, n10);
                    float f = this.gl.gl(this.marker, this.sampleA, by, by2);
                    if (!(f > 0.0f)) continue;
                    int n11 = this.dag.nOutEdges(this.marker, n5);
                    for (int k = 0; k < n11; ++k) {
                        int n12 = this.dag.outEdge(this.marker, n5, k);
                        byte by3 = this.dag.symbol(this.marker, n12);
                        int n13 = this.dag.nOutEdges(this.marker, n6);
                        for (int i2 = 0; i2 < n13; ++i2) {
                            double d3;
                            double d4;
                            double d5;
                            double d6;
                            double d7;
                            float f2;
                            int n14 = this.dag.outEdge(this.marker, n6, i2);
                            byte by4 = this.dag.symbol(this.marker, n14);
                            float f3 = this.gl.gl(this.marker, this.sampleB, by3, by4);
                            if (!(f3 > 0.0f) || !((f2 = this.gl.gl(this.marker, this.sampleC, by, by3)) > 0.0f)) continue;
                            if (this.size == this.capacity) {
                                this.ensureCapacity(this.size + 1);
                            }
                            if ((d7 = (double)(f * f3 * f2) * d2 * ((d6 = (double)this.dag.condEdgeProb(this.marker, n8)) * (d5 = (double)this.dag.condEdgeProb(this.marker, n10)) * (d4 = (double)this.dag.condEdgeProb(this.marker, n12)) * (d3 = (double)this.dag.condEdgeProb(this.marker, n14)))) < 4.94E-322 && d2 > 0.0) {
                                d7 = 4.94E-322;
                            }
                            this.edgesA1[this.size] = n8;
                            this.edgesA2[this.size] = n10;
                            this.edgesB1[this.size] = n12;
                            this.edgesB2[this.size] = n14;
                            this.fwdValues[this.size++] = d7;
                            d += d7;
                        }
                    }
                }
            }
        }
        assert (d > 0.0 ^ this.size == 0);
        n = 0;
        while (n < this.size) {
            int n15 = n++;
            this.fwdValues[n15] = this.fwdValues[n15] / d;
        }
        this.fwdValueSum = d;
    }

    public void setChildNodes(TrioNodes trioNodes) {
        trioNodes.clear();
        for (int i = 0; i < this.size; ++i) {
            int n = this.dag.childNode(this.marker, this.edgesA1[i]);
            int n2 = this.dag.childNode(this.marker, this.edgesA2[i]);
            int n3 = this.dag.childNode(this.marker, this.edgesB1[i]);
            int n4 = this.dag.childNode(this.marker, this.edgesB2[i]);
            trioNodes.sumUpdate(n, n2, n3, n4, this.fwdValues[i]);
        }
    }

    public void setInitialBackwardValues(TrioNodes trioNodes) {
        trioNodes.clear();
        for (int i = 0; i < this.size; ++i) {
            int n = this.dag.childNode(this.marker, this.edgesA1[i]);
            int n2 = this.dag.childNode(this.marker, this.edgesA2[i]);
            int n3 = this.dag.childNode(this.marker, this.edgesB1[i]);
            int n4 = this.dag.childNode(this.marker, this.edgesB2[i]);
            trioNodes.maxUpdate(n, n2, n3, n4, 1.0);
        }
        this.setBackwardValues(trioNodes);
    }

    public void setBackwardValues(TrioNodes trioNodes) {
        int n;
        this.bwdValueSum = 0.0;
        double d = 0.0;
        for (n = 0; n < this.size; ++n) {
            double d2;
            int by4 = this.dag.childNode(this.marker, this.edgesA1[n]);
            int n2 = this.dag.childNode(this.marker, this.edgesA2[n]);
            int n3 = this.dag.childNode(this.marker, this.edgesB1[n]);
            int n4 = this.dag.childNode(this.marker, this.edgesB2[n]);
            this.bwdValues[n] = d2 = trioNodes.value(by4, n2, n3, n4);
            this.bwdValueSum += d2;
        }
        trioNodes.clear();
        for (n = 0; n < this.size; ++n) {
            double d3;
            double d4;
            int n5 = n;
            this.bwdValues[n5] = this.bwdValues[n5] / this.bwdValueSum;
            byte by = this.symbolA1(n);
            byte by2 = this.symbolA2(n);
            byte by3 = this.symbolB1(n);
            byte by4 = this.symbolB2(n);
            int n6 = this.dag.parentNode(this.marker, this.edgesA1[n]);
            int n7 = this.dag.parentNode(this.marker, this.edgesA2[n]);
            int n8 = this.dag.parentNode(this.marker, this.edgesB1[n]);
            int n9 = this.dag.parentNode(this.marker, this.edgesB2[n]);
            double d5 = this.dag.condEdgeProb(this.marker, this.edgesA1[n]);
            double d6 = this.dag.condEdgeProb(this.marker, this.edgesA2[n]);
            double d7 = this.dag.condEdgeProb(this.marker, this.edgesB1[n]);
            double d8 = this.dag.condEdgeProb(this.marker, this.edgesB2[n]);
            double d9 = this.fwdValues[n] * this.bwdValues[n];
            int n10 = BasicGL.genotype(by, by2);
            int n11 = BasicGL.genotype(by3, by4);
            int n12 = BasicGL.genotype(by, by3);
            int n13 = n10;
            this.gtProbsA[n13] = this.gtProbsA[n13] + d9;
            int n14 = n11;
            this.gtProbsB[n14] = this.gtProbsB[n14] + d9;
            int n15 = n12;
            this.gtProbsC[n15] = this.gtProbsC[n15] + d9;
            d += d9;
            double d10 = this.gl.gl(this.marker, this.sampleA, by, by2);
            double d11 = this.bwdValues[n] * (d5 * d6 * d7 * d8) * (d10 * (d4 = (double)this.gl.gl(this.marker, this.sampleB, by3, by4)) * (d3 = (double)this.gl.gl(this.marker, this.sampleC, by, by3)));
            if (d11 < 4.94E-322 && this.bwdValues[n] > 0.0) {
                d11 = 4.94E-322;
            }
            trioNodes.sumUpdate(n6, n7, n8, n9, d11);
        }
        n = 0;
        while (n < this.nGenotypes) {
            int n16 = n;
            this.gtProbsA[n16] = this.gtProbsA[n16] / d;
            int n17 = n;
            this.gtProbsB[n17] = this.gtProbsB[n17] / d;
            int n18 = n++;
            this.gtProbsC[n18] = this.gtProbsC[n18] / d;
        }
    }

    public Dag dag() {
        return this.dag;
    }

    public GL gl() {
        return this.gl;
    }

    public int marker() {
        return this.marker;
    }

    public int nGenotypes() {
        return this.nGenotypes;
    }

    public double gtProbsA(int n) {
        this.checkGT(n);
        return this.gtProbsA[n];
    }

    public double gtProbsB(int n) {
        this.checkGT(n);
        return this.gtProbsB[n];
    }

    public double gtProbsC(int n) {
        this.checkGT(n);
        return this.gtProbsC[n];
    }

    private void checkGT(int n) {
        if (n >= this.nGenotypes) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
    }

    public int size() {
        return this.size;
    }

    private void checkIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(this.size));
        }
    }

    public int edgeA1(int n) {
        this.checkIndex(n);
        return this.edgesA1[n];
    }

    public int edgeA2(int n) {
        this.checkIndex(n);
        return this.edgesA2[n];
    }

    public int edgeB1(int n) {
        this.checkIndex(n);
        return this.edgesB1[n];
    }

    public int edgeB2(int n) {
        this.checkIndex(n);
        return this.edgesB2[n];
    }

    public int parentNodeA1(int n) {
        this.checkIndex(n);
        return this.dag.parentNode(this.marker, this.edgesA1[n]);
    }

    public int parentNodeA2(int n) {
        this.checkIndex(n);
        return this.dag.parentNode(this.marker, this.edgesA2[n]);
    }

    public int parentNodeB1(int n) {
        this.checkIndex(n);
        return this.dag.parentNode(this.marker, this.edgesB1[n]);
    }

    public int parentNodeB2(int n) {
        this.checkIndex(n);
        return this.dag.parentNode(this.marker, this.edgesB2[n]);
    }

    public int childNodeA1(int n) {
        this.checkIndex(n);
        return this.dag.childNode(this.marker, this.edgesA1[n]);
    }

    public int childNodeA2(int n) {
        this.checkIndex(n);
        return this.dag.childNode(this.marker, this.edgesA2[n]);
    }

    public int childNodeB1(int n) {
        this.checkIndex(n);
        return this.dag.childNode(this.marker, this.edgesB1[n]);
    }

    public int childNodeB2(int n) {
        this.checkIndex(n);
        return this.dag.childNode(this.marker, this.edgesB2[n]);
    }

    public byte symbolA1(int n) {
        return this.dag.symbol(this.marker, this.edgeA1(n));
    }

    public byte symbolA2(int n) {
        return this.dag.symbol(this.marker, this.edgeA2(n));
    }

    public byte symbolB1(int n) {
        return this.dag.symbol(this.marker, this.edgeB1(n));
    }

    public byte symbolB2(int n) {
        return this.dag.symbol(this.marker, this.edgeB2(n));
    }

    public double forwardValue(int n) {
        this.checkIndex(n);
        return this.fwdValues[n];
    }

    public double backwardValue(int n) {
        this.checkIndex(n);
        return this.bwdValues[n];
    }

    public double forwardValuesSum() {
        return this.fwdValueSum;
    }

    public double backwardValuesSum() {
        return this.bwdValueSum;
    }

    public String toString() {
        String string = " ";
        String string2 = " | ";
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("level=");
        stringBuilder.append(this.marker);
        stringBuilder.append(" size=");
        stringBuilder.append(this.size);
        stringBuilder.append(" forwardValuesSum=");
        stringBuilder.append(this.fwdValueSum);
        stringBuilder.append(" backwardSum=");
        stringBuilder.append(this.bwdValueSum);
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append("j=");
            stringBuilder.append(i);
            stringBuilder.append(": ");
            stringBuilder.append(this.edgeA1(i));
            stringBuilder.append(string);
            stringBuilder.append(this.edgeA2(i));
            stringBuilder.append(string);
            stringBuilder.append(this.edgeB1(i));
            stringBuilder.append(string);
            stringBuilder.append(this.edgeB2(i));
            stringBuilder.append(string);
            stringBuilder.append(this.forwardValue(i));
            stringBuilder.append(string);
            stringBuilder.append(this.backwardValue(i));
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private void ensureCapacity(int n) {
        if (n > this.capacity) {
            this.capacity = this.capacity * 3 / 2 + 1;
            if (this.capacity < n) {
                this.capacity = n;
            }
            this.edgesA1 = Arrays.copyOf(this.edgesA1, this.capacity);
            this.edgesA2 = Arrays.copyOf(this.edgesA2, this.capacity);
            this.edgesB1 = Arrays.copyOf(this.edgesB1, this.capacity);
            this.edgesB2 = Arrays.copyOf(this.edgesB2, this.capacity);
            this.fwdValues = Arrays.copyOf(this.fwdValues, this.capacity);
            this.bwdValues = Arrays.copyOf(this.bwdValues, this.capacity);
        }
    }
}

