/*
 * Decompiled with CFR 0.152.
 */
package main;

import blbutil.Const;
import blbutil.Validate;
import java.io.File;
import java.util.Map;

public final class Parameters {
    private final String[] args;
    private final File gt;
    private final File gl;
    private final File gtgl;
    private final File ref;
    private final String out;
    private final File excludesamples;
    private final File excludemarkers;
    private final File ped;
    private final String chrom;
    private final float maxlr;
    private final int nthreads;
    private final int window;
    private final int overlap;
    private final boolean gprobs;
    private final boolean impute;
    private final boolean usephase;
    private final float singlescale;
    private final float duoscale;
    private final float trioscale;
    private final int burnin_its;
    private final int phase_its;
    private final int impute_its;
    private final long seed;
    private final boolean ibd;
    private final float ibdlod;
    private final float ibdscale;
    private final int ibdtrim;
    private final File map;
    private final int nsamples;
    private final int buildwindow;

    public Parameters(String[] stringArray) {
        int n = Integer.MAX_VALUE;
        long l = Long.MIN_VALUE;
        long l2 = Long.MAX_VALUE;
        float f = Float.MIN_VALUE;
        float f2 = Float.MAX_VALUE;
        this.args = (String[])stringArray.clone();
        Map<String, String> map = Validate.argsToMap(stringArray, '=');
        this.gt = Validate.getFile(Validate.stringArg("gt", map, false, null, null));
        this.gl = Validate.getFile(Validate.stringArg("gl", map, false, null, null));
        this.gtgl = Validate.getFile(Validate.stringArg("gtgl", map, false, null, null));
        this.ref = Validate.getFile(Validate.stringArg("ref", map, false, null, null));
        this.out = Validate.stringArg("out", map, true, null, null);
        this.excludesamples = Validate.getFile(Validate.stringArg("excludesamples", map, false, null, null));
        this.excludemarkers = Validate.getFile(Validate.stringArg("excludemarkers", map, false, null, null));
        this.ped = Validate.getFile(Validate.stringArg("ped", map, false, null, null));
        this.chrom = Validate.stringArg("chrom", map, false, null, null);
        this.maxlr = Validate.floatArg("maxlr", map, false, 5000.0f, 1.1f, f2);
        this.window = Validate.intArg("window", map, false, 50000, 1, n);
        this.overlap = Validate.intArg("overlap", map, false, 3000, 0, n);
        this.gprobs = Validate.booleanArg("gprobs", map, false, true);
        this.impute = Validate.booleanArg("impute", map, false, true);
        this.usephase = Validate.booleanArg("usephase", map, false, false);
        this.singlescale = Validate.floatArg("singlescale", map, false, 0.8f, f, f2);
        this.duoscale = Validate.floatArg("duoscale", map, false, 1.0f, f, f2);
        this.trioscale = Validate.floatArg("trioscale", map, false, 1.0f, f, f2);
        this.burnin_its = Validate.intArg("burnin-its", map, false, 5, 0, n);
        this.phase_its = Validate.intArg("phase-its", map, false, 5, 0, n);
        this.impute_its = Validate.intArg("impute-its", map, false, 5, 0, n);
        this.nthreads = Validate.intArg("nthreads", map, false, 1, 1, 100000);
        this.seed = Validate.longArg("seed", map, false, -99999L, l, l2);
        this.ibd = Validate.booleanArg("ibd", map, false, false);
        this.ibdlod = Validate.floatArg("ibdlod", map, false, 3.0f, f, f2);
        this.ibdscale = Validate.floatArg("ibdscale", map, false, 0.0f, 0.0f, f2);
        this.ibdtrim = Validate.intArg("ibdtrim", map, false, 40, 0, n);
        this.map = Validate.getFile(Validate.stringArg("map", map, false, null, null));
        this.nsamples = Validate.intArg("nsamples", map, false, 4, 1, n);
        this.buildwindow = Validate.intArg("buildwindow", map, false, 1200, 1, n);
        Validate.confirmEmptyMap(map);
    }

    public String[] args() {
        return (String[])this.args.clone();
    }

    public static String usage() {
        String string = Const.nl;
        return "Command line syntax: java -jar beagle.jar [arguments]" + string + string + "data input/output parameters ..." + string + "  gt=<VCF file: use GT field>                        (optional)" + string + "  gl=<VCF file: use GL/PL field>                     (optional)" + string + "  gtgl=<VCF file: use GT and GL/PL fields>           (optional)" + string + "  ref=<VCF file with phased genotypes>               (optional)" + string + "  out=<output file prefix>                           (required)" + string + "  excludesamples=<file with 1 sample ID per line>    (optional)" + string + "  excludemarkers=<file with 1 marker ID per line>    (optional)" + string + "  ped=<linkage format pedigree file>                 (optional)" + string + "  chrom=<[chrom] or [chrom]:[start]-[end]>           (optional)" + string + "  maxlr=<max GL/PL likelihood ratio>                 (default=5000)" + string + string + "algorithm parameters ..." + string + "  nthreads=<number of threads>                       (default=1)" + string + "  window=<markers per window>                        (default=50000)" + string + "  overlap=<overlap between windows>                  (default=3000)" + string + "  gprobs=<print GP field (true/false)>               (default=true)" + string + "  impute=<impute ungenotyped variants (true/false)>  (default=true)" + string + "  usephase=<use phase in \"gt\" or \"gtgl\" file>        (default=false)" + string + "  singlescale=<model scale for singles>              (default=1.0)" + string + "  duoscale=<model scale for duos>                    (default=1.0)" + string + "  trioscale=<model scale trios>                      (default=1.0)" + string + "  burnin-its=<number of iterations>                  (default=5)" + string + "  phase-its=<number of iterations>                   (default=5)" + string + "  impute-its=<number of iterations>                  (default=5)" + string + "  seed=<random seed>                                 (default=-99999)" + string + string + "IBD parameters ..." + string + "  ibd=<perform IBD detection (true/false)>           (default=false)" + string + "  ibdlod=<min LOD score for reporting IBD>           (default=3.0)" + string + "  ibdscale=<model scale factor for Refined IBD>      (default: data-dependent)" + string + "  ibdtrim=<markers at each segment end>              (default=40)" + string;
    }

    public float adjustedIbdScale(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (this.ibdscale == 0.0f) {
            return Math.max(2.0f, (float)Math.sqrt((double)n / 100.0));
        }
        return this.ibdscale;
    }

    public File gt() {
        return this.gt;
    }

    public File gl() {
        return this.gl;
    }

    public File gtgl() {
        return this.gtgl;
    }

    public File ref() {
        return this.ref;
    }

    public String out() {
        return this.out;
    }

    public File excludesamples() {
        return this.excludesamples;
    }

    public File excludemarkers() {
        return this.excludemarkers;
    }

    public File ped() {
        return this.ped;
    }

    public String chrom() {
        return this.chrom;
    }

    public float maxlr() {
        return this.maxlr;
    }

    public int nthreads() {
        return this.nthreads;
    }

    public int window() {
        return this.window;
    }

    public int overlap() {
        return this.overlap;
    }

    public boolean gprobs() {
        return this.gprobs;
    }

    public boolean impute() {
        return this.impute;
    }

    public boolean usephase() {
        return this.usephase;
    }

    public float singlescale() {
        return this.singlescale;
    }

    public float duoscale() {
        return this.duoscale;
    }

    public float trioscale() {
        return this.trioscale;
    }

    public int burnin_its() {
        return this.burnin_its;
    }

    public int phase_its() {
        return this.phase_its;
    }

    public int impute_its() {
        return this.impute_its;
    }

    public long seed() {
        return this.seed;
    }

    public boolean ibd() {
        return this.ibd;
    }

    public float ibdlod() {
        return this.ibdlod;
    }

    public float ibdscale() {
        return this.ibdscale;
    }

    public int ibdtrim() {
        return this.ibdtrim;
    }

    public File map() {
        return this.map;
    }

    public int nsamples() {
        return this.nsamples;
    }

    public int buildwindow() {
        return this.buildwindow;
    }
}

