/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.SampleFileIterator;
import java.io.File;
import java.util.NoSuchElementException;
import vcf.BitSetRefGT;
import vcf.VcfEmission;
import vcf.VcfRecord;

public class VcfRefIterator
implements SampleFileIterator<VcfEmission> {
    private final SampleFileIterator<VcfRecord> it;

    public VcfRefIterator(SampleFileIterator<VcfRecord> sampleFileIterator) {
        if (sampleFileIterator.samples().nSamples() == 0) {
            String string = "missing sample data";
            throw new IllegalArgumentException(string);
        }
        this.it = sampleFileIterator;
    }

    @Override
    public Samples samples() {
        return this.it.samples();
    }

    @Override
    public File file() {
        return this.it.file();
    }

    @Override
    public void close() {
        this.it.close();
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public VcfEmission next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return new BitSetRefGT((VcfRecord)this.it.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("VcfRefIterator.remove()");
    }
}

