/*
 * Decompiled with CFR 0.152.
 */
package sample;

import dag.Dag;
import haplotype.BitHapPair;
import haplotype.HapPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import sample.TrioBaumLevel;
import sample.TrioNodes;
import vcf.GL;

public class TrioBaum {
    private final Dag dag;
    private final GL gl;
    private final int nMarkers;
    private final int nCopies;
    private final long seed;
    private final Random random;
    private final int[] nodeA1;
    private final int[] nodeA2;
    private final int[] nodeB1;
    private final int[] nodeB2;
    private final double[] nodeValue;
    private final byte[][] allelesA1;
    private final byte[][] allelesA2;
    private final byte[][] allelesB1;
    private final byte[][] allelesB2;
    private final TrioBaumLevel[] levels;
    private final TrioNodes fwdNodes;
    private final TrioNodes bwdNodes;
    private int windowIndex = -9999;
    private int arrayIndex = -9999;

    public TrioBaum(Dag dag, GL gL, long l, int n) {
        if (!dag.markers().equals(gL.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        if (n < 1) {
            throw new IllegalArgumentException("nCopies<1: " + n);
        }
        this.dag = dag;
        this.gl = gL;
        this.nMarkers = dag.nMarkers();
        this.nCopies = n;
        this.seed = l;
        this.random = new Random(l);
        this.nodeA1 = new int[n];
        this.nodeA2 = new int[n];
        this.nodeB1 = new int[n];
        this.nodeB2 = new int[n];
        this.nodeValue = new double[n];
        this.allelesA1 = new byte[n][gL.nMarkers()];
        this.allelesA2 = new byte[n][gL.nMarkers()];
        this.allelesB1 = new byte[n][gL.nMarkers()];
        this.allelesB2 = new byte[n][gL.nMarkers()];
        int n2 = (int)Math.ceil(Math.sqrt(1 + 8 * dag.nMarkers()) / 2.0) + 1;
        this.levels = new TrioBaumLevel[n2];
        for (int i = 0; i < this.levels.length; ++i) {
            this.levels[i] = new TrioBaumLevel(dag, gL);
        }
        this.fwdNodes = new TrioNodes();
        this.bwdNodes = new TrioNodes();
    }

    public Dag dag() {
        return this.dag;
    }

    public GL gl() {
        return this.gl;
    }

    public int nCopies() {
        return this.nCopies;
    }

    public long seed() {
        return this.seed;
    }

    public List<HapPair> sample(int n, int n2, int n3) {
        this.forwardAlgorithm(n, n2, n3);
        this.initSampleAlleles(this.currentLevel(), n, n2, n3);
        for (int i = this.nMarkers - 2; i >= 0; --i) {
            TrioBaumLevel trioBaumLevel = this.previousLevel(n, n2, n3);
            this.sampleAlleles(trioBaumLevel, n, n2, n3);
        }
        return this.hapList(n, n2, n3);
    }

    public List<HapPair> sample(int n, int n2, int n3, double[] dArray, double[] dArray2, double[] dArray3) {
        this.checkGtProbs(dArray, dArray2, dArray3);
        this.forwardAlgorithm(n, n2, n3);
        this.initSampleAlleles(this.currentLevel(), n, n2, n3);
        this.currentLevel().setInitialBackwardValues(this.bwdNodes);
        this.setGtProbs(this.currentLevel(), dArray, dArray2, dArray3);
        for (int i = this.nMarkers - 2; i >= 0; --i) {
            TrioBaumLevel trioBaumLevel = this.previousLevel(n, n2, n3);
            this.sampleAlleles(trioBaumLevel, n, n2, n3);
            trioBaumLevel.setBackwardValues(this.bwdNodes);
            this.setGtProbs(trioBaumLevel, dArray, dArray2, dArray3);
        }
        return this.hapList(n, n2, n3);
    }

    private void checkGtProbs(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = this.gl.markers().sumGenotypes();
        if (dArray.length != n || dArray2.length != n || dArray3.length != n) {
            String string = "array length error";
            throw new IllegalArgumentException(string);
        }
    }

    private void setGtProbs(TrioBaumLevel trioBaumLevel, double[] dArray, double[] dArray2, double[] dArray3) {
        int n = trioBaumLevel.marker();
        int n2 = this.gl.marker(n).nGenotypes();
        int n3 = this.gl.markers().sumGenotypes(n);
        for (int i = 0; i < n2; ++i) {
            dArray[n3 + i] = trioBaumLevel.gtProbsA(i);
            dArray2[n3 + i] = trioBaumLevel.gtProbsB(i);
            dArray3[n3 + i] = trioBaumLevel.gtProbsC(i);
        }
    }

    private List<HapPair> hapList(int n, int n2, int n3) {
        ArrayList<HapPair> arrayList = new ArrayList<HapPair>(2 * this.nCopies);
        for (int i = 0; i < this.nCopies; ++i) {
            BitHapPair bitHapPair = new BitHapPair(this.gl.markers(), this.gl.samples().idIndex(n), this.allelesA1[i], this.allelesA2[i]);
            BitHapPair bitHapPair2 = new BitHapPair(this.gl.markers(), this.gl.samples().idIndex(n2), this.allelesB1[i], this.allelesB2[i]);
            BitHapPair bitHapPair3 = new BitHapPair(this.gl.markers(), this.gl.samples().idIndex(n3), this.allelesA1[i], this.allelesB1[i]);
            arrayList.add(bitHapPair);
            arrayList.add(bitHapPair2);
            arrayList.add(bitHapPair3);
        }
        return arrayList;
    }

    private void initSampleAlleles(TrioBaumLevel trioBaumLevel, int n, int n2, int n3) {
        int n4 = trioBaumLevel.marker();
        for (int i = 0; i < this.nCopies; ++i) {
            int n5 = this.initialRandomState(trioBaumLevel);
            this.nodeA1[i] = trioBaumLevel.parentNodeA1(n5);
            this.nodeA2[i] = trioBaumLevel.parentNodeA2(n5);
            this.nodeB1[i] = trioBaumLevel.parentNodeB1(n5);
            this.nodeB2[i] = trioBaumLevel.parentNodeB2(n5);
            this.nodeValue[i] = this.parentSum(trioBaumLevel, n, n2, n3, n5);
            this.allelesA1[i][n4] = trioBaumLevel.symbolA1(n5);
            this.allelesA2[i][n4] = trioBaumLevel.symbolA2(n5);
            this.allelesB1[i][n4] = trioBaumLevel.symbolB1(n5);
            this.allelesB2[i][n4] = trioBaumLevel.symbolB2(n5);
        }
    }

    private int initialRandomState(TrioBaumLevel trioBaumLevel) {
        double d = this.random.nextDouble();
        double d2 = 0.0;
        int n = trioBaumLevel.size();
        for (int i = 0; i < n; ++i) {
            if (!(d <= (d2 += trioBaumLevel.forwardValue(i)))) continue;
            return i;
        }
        assert (false);
        return trioBaumLevel.size() - 1;
    }

    private double parentSum(TrioBaumLevel trioBaumLevel, int n, int n2, int n3, int n4) {
        int n5 = trioBaumLevel.marker();
        double d = trioBaumLevel.forwardValuesSum() * trioBaumLevel.forwardValue(n4);
        int n6 = trioBaumLevel.edgeA1(n4);
        int n7 = trioBaumLevel.edgeA2(n4);
        int n8 = trioBaumLevel.edgeB1(n4);
        int n9 = trioBaumLevel.edgeB2(n4);
        double d2 = this.dag.condEdgeProb(n5, n6);
        double d3 = this.dag.condEdgeProb(n5, n7);
        double d4 = this.dag.condEdgeProb(n5, n8);
        double d5 = this.dag.condEdgeProb(n5, n9);
        byte by = this.dag.symbol(n5, n6);
        byte by2 = this.dag.symbol(n5, n7);
        byte by3 = this.dag.symbol(n5, n8);
        byte by4 = this.dag.symbol(n5, n9);
        double d6 = this.gl.gl(n5, n, by, by2);
        double d7 = this.gl.gl(n5, n2, by3, by4);
        double d8 = this.gl.gl(n5, n3, by, by3);
        return d / (d6 * d7 * d8 * (d2 * d3 * d4 * d5));
    }

    private void sampleAlleles(TrioBaumLevel trioBaumLevel, int n, int n2, int n3) {
        int n4 = trioBaumLevel.marker();
        for (int i = 0; i < this.nCopies; ++i) {
            int n5 = this.randomPreviousState(trioBaumLevel, this.nodeA1[i], this.nodeA2[i], this.nodeB1[i], this.nodeB2[i], this.nodeValue[i]);
            this.nodeA1[i] = trioBaumLevel.parentNodeA1(n5);
            this.nodeA2[i] = trioBaumLevel.parentNodeA2(n5);
            this.nodeB1[i] = trioBaumLevel.parentNodeB1(n5);
            this.nodeB2[i] = trioBaumLevel.parentNodeB2(n5);
            this.nodeValue[i] = this.parentSum(trioBaumLevel, n, n2, n3, n5);
            this.allelesA1[i][n4] = trioBaumLevel.symbolA1(n5);
            this.allelesA2[i][n4] = trioBaumLevel.symbolA2(n5);
            this.allelesB1[i][n4] = trioBaumLevel.symbolB1(n5);
            this.allelesB2[i][n4] = trioBaumLevel.symbolB2(n5);
        }
    }

    private int randomPreviousState(TrioBaumLevel trioBaumLevel, int n, int n2, int n3, int n4, double d) {
        double d2 = this.random.nextDouble() * d;
        double d3 = 0.0;
        int n5 = trioBaumLevel.size();
        for (int i = 0; i < n5; ++i) {
            if (n != trioBaumLevel.childNodeA1(i) || n2 != trioBaumLevel.childNodeA2(i) || n3 != trioBaumLevel.childNodeB1(i) || n4 != trioBaumLevel.childNodeB2(i) || !(d2 <= (d3 += trioBaumLevel.forwardValue(i)))) continue;
            return i;
        }
        return trioBaumLevel.size() - 1;
    }

    private TrioBaumLevel nextLevel() {
        ++this.arrayIndex;
        if (this.arrayIndex == this.levels.length) {
            ++this.windowIndex;
            this.arrayIndex = this.windowIndex;
        }
        return this.levels[this.arrayIndex];
    }

    private TrioBaumLevel currentLevel() {
        return this.levels[this.arrayIndex];
    }

    private TrioBaumLevel previousLevel(int n, int n2, int n3) {
        if (this.arrayIndex == this.windowIndex) {
            --this.windowIndex;
            this.arrayIndex = this.windowIndex;
            this.levels[this.arrayIndex].setChildNodes(this.fwdNodes);
            int n4 = this.levels[this.windowIndex].marker() + 1;
            int n5 = n4 + (this.levels.length - (this.windowIndex + 1));
            for (int i = n4; i < n5; ++i) {
                this.nextLevel().setForwardValues(this.fwdNodes, i, n, n2, n3);
            }
            return this.currentLevel();
        }
        return this.levels[--this.arrayIndex];
    }

    private void forwardAlgorithm(int n, int n2, int n3) {
        TrioBaumLevel.initializeNodes(this.fwdNodes);
        this.windowIndex = -1;
        this.arrayIndex = this.levels.length - 1;
        for (int i = 0; i < this.nMarkers; ++i) {
            this.nextLevel().setForwardValues(this.fwdNodes, i, n, n2, n3);
        }
    }
}

