/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import blbutil.FileIterator;
import haplotype.HapPairs;
import haplotype.HapsMarker;
import java.io.File;
import vcf.Marker;

public class HapsMarkerIterator
implements FileIterator<HapsMarker> {
    private final HapPairs haps;
    private int nextIndex = 0;

    public HapsMarkerIterator(HapPairs hapPairs) {
        if (hapPairs == null) {
            throw new NullPointerException("haps==nullt");
        }
        this.haps = hapPairs;
    }

    @Override
    public File file() {
        return null;
    }

    @Override
    public void close() {
        this.nextIndex = this.haps.nMarkers();
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex < this.haps.nMarkers();
    }

    @Override
    public HapsMarker next() {
        final int n = this.nextIndex++;
        return new HapsMarker(){

            @Override
            public byte allele(int n2) {
                return HapsMarkerIterator.this.haps.allele(n, n2);
            }

            @Override
            public byte allele1(int n2) {
                return HapsMarkerIterator.this.haps.allele(n, 2 * n2);
            }

            @Override
            public byte allele2(int n2) {
                return HapsMarkerIterator.this.haps.allele(n, 2 * n2 + 1);
            }

            @Override
            public Marker marker() {
                return HapsMarkerIterator.this.haps.marker(n);
            }

            @Override
            public int nHaps() {
                return HapsMarkerIterator.this.haps.nHaps();
            }

            @Override
            public int nHapPairs() {
                return HapsMarkerIterator.this.haps.nHapPairs();
            }

            @Override
            public int idIndex(int n2) {
                return HapsMarkerIterator.this.haps.idIndex(n2);
            }
        };
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }
}

