/*
 * Decompiled with CFR 0.152.
 */
package dag;

import blbutil.Const;
import blbutil.IndexSet;
import dag.DagLevel;
import java.util.Arrays;
import vcf.Marker;

public final class ImmutableDagLevel
implements DagLevel {
    private final Marker marker;
    private final float count;
    private final char[] parentNodes;
    private final char[] childNodes;
    private final char[] parentIndices;
    private final char[] parents;
    private final char[] childIndices;
    private final char[] children;
    private final byte[] symbols;
    private final float[] edgeCounts;
    private final float[] condEdgeProbs;
    private final float[] nodeCounts;

    public ImmutableDagLevel(Marker marker, char[] cArray, char[] cArray2, byte[] byArray, float[] fArray) {
        int n = ImmutableDagLevel.checkLengths(cArray, cArray2, byArray, fArray);
        ImmutableDagLevel.checkSymbols(marker, byArray);
        this.marker = marker;
        this.parentIndices = ImmutableDagLevel.getIndicesArray(cArray);
        this.childIndices = ImmutableDagLevel.getIndicesArray(cArray2);
        this.parentNodes = (char[])cArray.clone();
        this.childNodes = (char[])cArray2.clone();
        this.symbols = (byte[])byArray.clone();
        this.edgeCounts = (float[])fArray.clone();
        this.condEdgeProbs = new float[n];
        this.parents = new char[n];
        this.children = new char[n];
        char[] cArray3 = Arrays.copyOfRange(this.parentIndices, 0, this.parentIndices.length - 1);
        char[] cArray4 = Arrays.copyOfRange(this.childIndices, 0, this.childIndices.length - 1);
        this.nodeCounts = this.nodeCnts(cArray, fArray, cArray3.length);
        this.count = this.sum(this.nodeCounts);
        for (int n2 = 0; n2 < n; n2 = (int)((char)(n2 + 1))) {
            char c = cArray[n2];
            char c2 = cArray2[n2];
            char c3 = c;
            char c4 = cArray3[c3];
            cArray3[c3] = (char)(c4 + '\u0001');
            this.parents[c4] = n2;
            char c5 = c2;
            char c6 = cArray4[c5];
            cArray4[c5] = (char)(c6 + '\u0001');
            this.children[c6] = n2;
            this.condEdgeProbs[n2] = fArray[n2] / this.nodeCounts[c];
        }
        ImmutableDagLevel.checkForDuplicateOutEdges(this.parentIndices, this.parents, byArray, marker.nAlleles());
    }

    private static int checkLengths(char[] cArray, char[] cArray2, byte[] byArray, float[] fArray) {
        if (cArray.length > 65535) {
            String string = "parentNodes.length>Character.MAX_VALUE";
            throw new IllegalArgumentException(string);
        }
        if (cArray.length != cArray2.length || cArray.length != byArray.length || cArray.length != fArray.length) {
            throw new IllegalArgumentException("inconsistent arrays");
        }
        return cArray.length;
    }

    private static void checkSymbols(Marker marker, byte[] byArray) {
        int n = marker.nAlleles();
        for (byte by : byArray) {
            if (by >= 0 && by < n) continue;
            throw new IllegalArgumentException("symbol: " + by);
        }
    }

    private static void checkForDuplicateOutEdges(char[] cArray, char[] cArray2, byte[] byArray, int n) {
        IndexSet indexSet = new IndexSet(n);
        for (int i = 1; i < cArray.length; ++i) {
            indexSet.clear();
            char c = cArray[i];
            for (int j = cArray[i - 1]; j < c; ++j) {
                char c2 = cArray2[j];
                if (indexSet.add(byArray[c2])) continue;
                throw new IllegalArgumentException("duplicate edge");
            }
        }
    }

    private static char[] getIndicesArray(char[] cArray) {
        int[] nArray = ImmutableDagLevel.elementCounts(cArray);
        char[] cArray2 = new char[nArray.length + 1];
        for (int i = 1; i < cArray2.length; ++i) {
            assert (nArray[i - 1] > 0);
            int n = cArray2[i - 1] + nArray[i - 1];
            assert (n <= 65535);
            cArray2[i] = (char)n;
        }
        return cArray2;
    }

    private static int[] elementCounts(char[] cArray) {
        int n = ImmutableDagLevel.max(cArray);
        int[] nArray = new int[n + 1];
        char[] cArray2 = cArray;
        int n2 = cArray2.length;
        for (int i = 0; i < n2; ++i) {
            char c;
            char c2 = c = cArray2[i];
            nArray[c2] = nArray[c2] + 1;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 0) continue;
            throw new IllegalArgumentException("no element with value " + i);
        }
        return nArray;
    }

    private static int max(char[] cArray) {
        char c = '\u0000';
        for (char c2 : cArray) {
            if (c2 <= c) continue;
            c = c2;
        }
        return c;
    }

    private float sum(float[] fArray) {
        float f = 0.0f;
        for (float f2 : fArray) {
            f += f2;
        }
        return f;
    }

    private float[] nodeCnts(char[] cArray, float[] fArray, int n) {
        float[] fArray2 = new float[n];
        for (int i = 0; i < this.condEdgeProbs.length; ++i) {
            char c;
            char c2 = c = cArray[i];
            fArray2[c2] = fArray2[c2] + fArray[i];
        }
        return fArray2;
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public int nEdges() {
        return this.condEdgeProbs.length;
    }

    @Override
    public char nParentNodes() {
        return (char)(this.parentIndices.length - 1);
    }

    @Override
    public int nChildNodes() {
        return this.childIndices.length - 1;
    }

    @Override
    public char parentNode(int n) {
        return this.parentNodes[n];
    }

    @Override
    public char childNode(int n) {
        return this.childNodes[n];
    }

    @Override
    public byte symbol(int n) {
        return this.symbols[n];
    }

    @Override
    public float edgeCnt(int n) {
        return this.edgeCounts[n];
    }

    @Override
    public float nodeCnt(int n) {
        return this.nodeCounts[n];
    }

    @Override
    public float condEdgeProb(int n) {
        return this.condEdgeProbs[n];
    }

    @Override
    public float edgeProb(int n) {
        return this.edgeCounts[n] / this.count;
    }

    @Override
    public float nodeProb(int n) {
        return this.nodeCounts[n] / this.count;
    }

    @Override
    public char nOutEdges(int n) {
        return (char)(this.parentIndices[n + 1] - this.parentIndices[n]);
    }

    @Override
    public char outEdge(int n, int n2) {
        if (n2 < 0 || n2 >= this.nOutEdges(n)) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        return this.parents[this.parentIndices[n] + n2];
    }

    @Override
    public char outEdgeBySymbol(int n, byte by) {
        if (by < 0 || by >= this.marker.nAlleles()) {
            throw new IndexOutOfBoundsException(String.valueOf(by));
        }
        char c = this.parentIndices[n];
        char c2 = this.parentIndices[n + 1];
        for (char c3 = c; c3 < c2; c3 = (char)(c3 + '\u0001')) {
            char c4 = this.parents[c3];
            if (this.symbols[c4] != by) continue;
            return c4;
        }
        return '\uffff';
    }

    @Override
    public char nInEdges(int n) {
        return (char)(this.childIndices[n + 1] - this.childIndices[n]);
    }

    @Override
    public char inEdge(int n, int n2) {
        if (n2 < 0 || n2 >= this.nInEdges(n)) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        return this.children[this.childIndices[n] + n2];
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append(Const.nl);
        stringBuilder.append("parentNodes=");
        stringBuilder.append(ImmutableDagLevel.charArrayToString(this.parentNodes));
        stringBuilder.append(Const.nl);
        stringBuilder.append("childNodes=");
        stringBuilder.append(ImmutableDagLevel.charArrayToString(this.childNodes));
        stringBuilder.append(Const.nl);
        stringBuilder.append("symbols=");
        stringBuilder.append(Arrays.toString(this.symbols));
        stringBuilder.append(Const.nl);
        stringBuilder.append("condEdgeProbs=");
        stringBuilder.append(Arrays.toString(this.condEdgeProbs));
        stringBuilder.append(Const.nl);
        stringBuilder.append("edgeCounts=");
        stringBuilder.append(Arrays.toString(this.condEdgeProbs));
        stringBuilder.append(Const.nl);
        stringBuilder.append("nodeCounts=");
        stringBuilder.append(Arrays.toString(this.edgeCounts));
        stringBuilder.append(Const.nl);
        stringBuilder.append("parentIndices=");
        stringBuilder.append(ImmutableDagLevel.charArrayToString(this.parentIndices));
        stringBuilder.append(Const.nl);
        stringBuilder.append("parents=");
        stringBuilder.append(ImmutableDagLevel.charArrayToString(this.parents));
        stringBuilder.append(Const.nl);
        stringBuilder.append("childIndices=");
        stringBuilder.append(ImmutableDagLevel.charArrayToString(this.childIndices));
        stringBuilder.append(Const.nl);
        stringBuilder.append("children=");
        stringBuilder.append(ImmutableDagLevel.charArrayToString(this.children));
        return stringBuilder.toString();
    }

    private static String charArrayToString(char[] cArray) {
        StringBuilder stringBuilder = new StringBuilder(cArray.length * 4 + 10);
        stringBuilder.append("[");
        stringBuilder.append((int)cArray[0]);
        for (int i = 1; i < cArray.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append((int)cArray[i]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

