% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\docType{methods}
\name{changeVariables}
\alias{changeVariables}
\alias{changeVariables,symbolicQspray,list-method}
\title{Change of variables in a 'symbolicQspray' polynomial}
\usage{
\S4method{changeVariables}{symbolicQspray,list}(x, listOfQsprays)
}
\arguments{
\item{x}{a \code{symbolicQspray} polynomial}

\item{listOfQsprays}{a list containing at least \code{n}
\code{symbolicQspray} objects, or objects coercible to
\code{symbolicQspray} objects, where \code{n} is the number of
variables in the polynomial given in the \code{x} argument}
}
\value{
The \code{symbolicQspray} polynomial obtained by replacing the
  variables of the polynomial given in the \code{x} argument with the
  polynomials given in the \code{listOfQsprays} argument.
}
\description{
Replaces the variables of a \code{symbolicQspray} polynomial
  with some \code{symbolicQspray} polynomials. E.g. you have a polynomial
  \eqn{P_a(x, y)} and you want the polynomial \eqn{P_a(x+a, y+a)} (see
  example).
}
\examples{
library(symbolicQspray)
f <- function(a, X, Y) {
  a^2 / (a + 1) * X^2*Y  +  (3*a - 2) / a * Y^2
}
a <- qlone(1)
X <- Qlone(1)
Y <- Qlone(2)
Qspray <- f(a, X, Y)
U <- X + a
V <- Y + a
changeVariables(Qspray, list(U, V)) == f(a, U, V) # should be TRUE
}
\seealso{
If you want to change the parameters of a symbolic qspray, use
  \code{\link{changeParameters}}. If you want to assign some values to
  its variables, see \code{\link{substituteVariables}}.
}
