\name{oneGeneDel}
\alias{oneGeneDel}

\encoding{utf8}

\title{Single Gene Deletion Experiment}

\description{
  Predict the metabolic phenotype of single-gene knock out mutants.
}

\usage{
  oneGeneDel(model, geneList, ...)
}

\arguments{
  \item{model}{
    An object of class \code{\linkS4class{modelorg}}.
  }
  \item{geneList}{
    A character vector containing the set of genes to be deleted one by one.\cr
    Default: \code{allGenes(model)}.
  }
  \item{\dots}{
    Further arguments passed to \code{\link{optimizer}}.  Important ones are
    \code{algorithm} in order to set the algorithm to use or \code{solverParm}
    in order to set parameter values for the optimization software.
  }
}

\details{
  The function \code{oneGeneDel} studies the effect of genetic perturbations
  by single gene deletions on the phenotype of the metabolic network. The
  function performs \eqn{n} optimizations with \eqn{n} being the length of the
  character vector in argument \code{geneList}. For each gene deletion \eqn{j}
  the set of fluxes effected by the deletion of gene given in \code{geneList[j]}
  is constrained to zero flux. If the deletion of a certain gene has an effect,
  is tested with the function \code{\link{geneDel}}. Each optimization
  corresponds to the deletion of one gene.
}

\value{
  An object of class \code{\linkS4class{optsol_genedel}}.
}

\author{Gabriel Gelius-Dietrich}

\seealso{
  \code{\link{modelorg}}, \code{\linkS4class{optsol}},
  \code{\linkS4class{optsol_genedel}},
  \code{\link{checkOptSol}}, \code{\link{optimizer}} and
  \code{\link{SYBIL_SETTINGS}}.
}

\examples{
  # load example data set
  data(Ec_core)
  
  # compute phenotypes of genetic pertubations via
  # FBA (default)
  Ec_ogd <- oneGeneDel(Ec_core)
  
  # or MOMA (linearized version)
  Ec_ogd <- oneGeneDel(Ec_core, algorithm = "lmoma")
}

\keyword{optimize}

