##' publishManifest
##'
##' Publish a package or session manifest to file.
##'
##' @param manifest The object to save as a serialized package or session
##' manifest. Defaulst to the currently in use switchr library.
##' A session manifest will be generated by libManifest as necessary.
##' @param dest The destination \code{manifest} will be published to. Typically
##' a character value indicating a file name (including path) to write to.
##' @param \dots Unused
##'
##' @return The name of the file written 
##'@docType methods
##' @rdname publishManifest
##' @export
setGeneric("publishManifest", function(manifest, dest = "./pkg_manifest.rman",...) standardGeneric("publishManifest"))
##' @rdname publishManifest
##' @aliases publishManifest,PkgManifest,character
setMethod("publishManifest", c(manifest = "PkgManifest",
                               dest = "character"),
          
          function(manifest, dest, ...) {
              con = file(dest, "w")
              cat("# R manifest\n", file = con)
              cat("# Manifest type: package\n", file = con, append = TRUE)
              cat(sprintf("# Dependency repositories: %d\n",
                          length(dep_repos(manifest))),
                  file = con, append = TRUE)
              sapply(dep_repos(manifest), function(x) {
                  cat(sprintf("# repo: %s\n", x), file = con,
                      append = TRUE)
              })
              ## write.table complains about column names with append=TRUE, but
              ## it's fine because all the previous lines are comments.
              res = tryCatch(write.table(manifest_df(manifest), file = con, append=TRUE,
                          sep = ","), warning=function(w) NULL)

              close(con)
              dest
          })

##' @rdname publishManifest
##' @aliases publishManifest,SessionManifest,character

setMethod("publishManifest", c("SessionManifest", "character"),
          function(manifest, dest, ...) {
              con = file(dest, "w")
              cat("# R manifest\n", file = con)
              cat("# Manifest type: session\n", file = con, append = TRUE)
              cat(sprintf("# Dependency repositories: %d\n",
                          length(dep_repos(manifest))),
                  file = con, append = TRUE)
              sapply(dep_repos(manifest), function(x) {
                  cat(sprintf("# repo: %s\n", x), file = con,
                      append = TRUE)
              })

              df = manifest_df(manifest)
              df = merge(df, versions_df(manifest), by = "name")
              ## write.table complains about column names with append=TRUE, but
              ## it's fine because all the previous lines are comments.
              res = tryCatch(write.table(df, file = con, append=TRUE,
                          sep = ","), warning=function(w) NULL)

              close(con)
              dest
          })

##' @rdname publishManifest
##' @aliases publishManifest,missing,ANY

setMethod("publishManifest", c(manifest = "missing", dest = "ANY"),
          function(manifest, dest, ...) {
              publishManifest(currentCompEnv(), dest = dest, ...)
          })
##' @rdname publishManifest
##' @aliases publishManifest,SwitchrCtx,ANY

setMethod("publishManifest", c(manifest = "SwitchrCtx", dest = "ANY"),
          function(manifest, dest, ...) {
              publishManifest(libManifest(manifest, ...), dest = dest, ...)
          })
