% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airdas_chop_section.R
\name{airdas_chop_section}
\alias{airdas_chop_section}
\alias{airdas_chop_section.data.frame}
\alias{airdas_chop_section.airdas_df}
\title{Chop AirDAS data - section}
\usage{
airdas_chop_section(x, ...)

\method{airdas_chop_section}{data.frame}(x, ...)

\method{airdas_chop_section}{airdas_df}(
  x,
  conditions,
  distance.method = NULL,
  num.cores = NULL,
  ...
)
}
\arguments{
\item{x}{\code{airdas_df} object, 
or a data frame that can be coerced to a \code{airdas_df} object. 
This data must be filtered for 'OnEffort' events; 
see the Details section below}

\item{...}{ignored}

\item{conditions}{see \code{\link{airdas_effort}}}

\item{distance.method}{character; see \code{\link{airdas_effort}}.
Default is \code{NULL} since these distances should have already been
calculated in \code{\link{airdas_effort}}}

\item{num.cores}{See \code{\link{airdas_effort}}}
}
\value{
See \code{\link{airdas_chop_equallength}}. 
  The randpicks values will all be \code{NA}
}
\description{
Chop AirDAS data into effort segments by continuous effort section
}
\details{
WARNING - do not call this function directly!
  It is exported for documentation purposes, but is intended for internal package use only.

  This function is simply a wrapper for \code{\link{airdas_chop_equallength}}.
  It calls \code{\link{airdas_chop_equallength}}, with \code{seg.km} set to a 
  value larger than the longest continuous effort section in \code{x}. 
  Thus, the effort is 'chopped' into the continuous effort sections and then summarized.
  
  See the Examples section for an example where the two methods give the same output.
  Note that the longest continuous effort section in the sample data is ~32km.
  
  For an example of how to summarize data by transect, 
  see \code{vignette("swfscAirDAS")}.
  In short, if looking to group by individual transects, use 
  \code{segdata$transect_idx <- cumsum(segdata$event == "T")} 
  to create a column with a transect index. 
  Then you can use \code{\link[dplyr]{group_by}(transect_idx)} and 
  \code{\link[dplyr]{summarise}} to summarise the desired data by transect
}
\examples{
y <- system.file("airdas_sample.das", package = "swfscAirDAS")
y.proc <- airdas_process(y)

y.eff1 <- airdas_effort(y.proc, method = "equallength", seg.km = 35, num.cores = 1)
y.eff2 <- airdas_effort(y.proc, method = "section", num.cores = 1)

all.equal(y.eff1, y.eff2)

}
