% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw_tidy_decomp.R
\name{sw_tidy_decomp}
\alias{sw_tidy_decomp}
\title{Coerces decomposed time-series objects to tibble format.}
\usage{
sw_tidy_decomp(x, timekit_idx = FALSE, rename_index = "index", ...)
}
\arguments{
\item{x}{A time-series object of class \code{stl}, \code{ets}, \code{decomposed.ts}, \code{HoltWinters},
\code{bats} or \code{tbats}.}

\item{timekit_idx}{When \code{TRUE}, uses a timekit index (irregular, typically date or datetime) if present.}

\item{rename_index}{Enables the index column to be renamed.}

\item{...}{Not used.}
}
\value{
Returns a \code{tibble} object.
}
\description{
Coerces decomposed time-series objects to tibble format.
}
\details{
\code{sw_tidy_decomp} is designed
to coerce time-series objects with decompositions to \code{tibble} objects.

A regularized time index is always constructed. If no time index is
detected, a sequential index is returned as a default.
The index column name can be changed using the \code{rename_index} argument.
}
\examples{
library(forecast)
library(sweep)

# Decompose ETS model
USAccDeaths \%>\%
    ets() \%>\%
    sw_tidy_decomp()

# Decompose STL object
USAccDeaths \%>\%
    stl(s.window = 'periodic') \%>\%
    sw_tidy_decomp()


}
