% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs.r
\name{dist_chisquare}
\alias{dist_chisquare}
\alias{dist_chisq}
\title{Compute Chi-square Distances}
\usage{
dist_chisquare(x, diag = FALSE, upper = FALSE)

dist_chisq(x, diag = FALSE, upper = FALSE)
}
\arguments{
\item{x}{A numeric matrix (containing coordinates).}

\item{diag}{Logical specifying whether the diagonal of the resulting distance matrix should be printed.}

\item{upper}{Logical specifying whether the upper triangle of the resulting distance matrix should be printed.}
}
\value{
A distance matrix.
}
\description{
A function for computing chi-square distances.
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\t", quote = "\"", encoding = "UTF-8",
   stringsAsFactors = FALSE)
tab.SndT_Fra <- table(SndT_Fra)
dist_chisquare(tab.SndT_Fra)
}
