% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lou_vax_data.R
\docType{data}
\name{lou_pums_microdata}
\alias{lou_pums_microdata}
\title{ACS PUMS Data for Louisville}
\format{
A data frame with 80 rows and 85 variables
\itemize{
  \item UNIQUE_ID: Unique identifier for records
  \item AGE: Age in years (copied from the AGEP variable in the ACS microdata)
  \item RACE_ETHNICITY: Race and Hispanic/Latino ethnicity
    derived from RAC1P and HISP variables
    of ACS microdata and collapsed to a smaller number of categories.
  \item SEX: Male or Female
  \item EDUC_ATTAINMENT: Highest level of education attained ('Less than high school' or 'High school or beyond')
    derived from SCHL variable in ACS microdata and collapsed to a smaller number of categories.
  \item PWGTP: Weights for the full-sample
  \item PWGTP1-PWGTP80: 80 columns of replicate weights
    created using the Successive Differences Replication (SDR) method.
}
}
\usage{
data(lou_pums_microdata)
}
\description{
Person-level microdata from the American Community Survey (ACS) 2015-2019
public-use microdata sample (PUMS) data for Louisville, KY. This microdata sample
represents all adults (persons aged 18 or over) in Louisville, KY. \cr

These data include replicate weights to use for variance estimation.
}
\examples{
\dontrun{
data(lou_pums_microdata)

# Prepare the data for analysis with the survey package
  library(survey)

  lou_pums_rep_design <- survey::svrepdesign(
    data = lou_pums_microdata,
    variables = ~ UNIQUE_ID + AGE + SEX + RACE_ETHNICITY + EDUC_ATTAINMENT,
    weights = ~ PWGTP, repweights = "PWGTP\\\\d{1,2}",
    type = "successive-difference",
    mse = TRUE
  )

# Estimate population proportions
  svymean(~ SEX, design = lou_pums_rep_design)
}
}
\keyword{datasets}
