#   R package for Singular Spectrum Analysis
#   Copyright (c) 2009 Anton Korobeynikov <asl@math.spbu.ru>
#
#   This program is free software; you can redistribute it
#   and/or modify it under the terms of the GNU General Public
#   License as published by the Free Software Foundation;
#   either version 2 of the License, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be
#   useful, but WITHOUT ANY WARRANTY; without even the implied
#   warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#   PURPOSE.  See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public
#   License along with this program; if not, write to the
#   Free Software Foundation, Inc., 675 Mass Ave, Cambridge,
#   MA 02139, USA.

#   Routines for external matrix stuff

extmat.ncol <- function(X) {
  .Call("extmat_cols", X)
}

extmat.nrow <- function(X) {
  .Call("extmat_rows", X)
}

is.extmat <- function(X) {
  .Call("is_extmat", X)
}

ematmul <- function(emat, v, transposed = FALSE) {
  storage.mode(v) <- "double";
  storage.mode(transposed) <- "logical";
  .Call("ematmul", emat, v, transposed);
}

extmat <- function(mul, tmul, nrow, ncol,
                   env = .GlobalEnv) {
  .Call("initialize_extmat",
        as.function(mul), as.function(tmul),
        as.integer(nrow), as.integer(ncol), env)
}
