% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahreg.R
\name{ahreg}
\alias{ahreg}
\title{Fitting Accelerated Hazard Models}
\usage{
ahreg(
  formula,
  data,
  baseline = c("exponential", "weibull", "lognormal", "loglogistic"),
  dist = NULL,
  init = 0,
  ...
)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{data an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which function is called.}

\item{baseline}{the chosen baseline distribution; options currently available are: exponential, weibull, lognormal and loglogistic distributions.}

\item{dist}{alternative way to specify the baseline distribution (for compability with the \code{\link[survival]{survreg}} function); default is NULL.}

\item{init}{initial values specification (default value is 0); see the detailed documentation for \code{init} in \code{\link[rstan]{optimizing}}.}

\item{...}{further arguments passed to other methods.}
}
\value{
ahreg returns an object of class "ahreg" containing the fitted model.
}
\description{
Function to fit accelerated hazard (AH) models.
}
\examples{
\donttest{
library(survstan)
fit <- ahreg(Surv(futime, fustat) ~ ecog.ps + rx, data = ovarian, baseline = "weibull", init = 0)
summary(fit)
}


}
