% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnnsurv.R
\name{dnnsurv}
\alias{dnnsurv}
\title{DNNSurv Neural Network for Conditional Survival Probabilities}
\usage{
dnnsurv(
  formula = NULL,
  data = NULL,
  reverse = FALSE,
  time_variable = "time",
  status_variable = "status",
  x = NULL,
  y = NULL,
  cutpoints = NULL,
  cuts = 5L,
  custom_model = NULL,
  loss_weights = NULL,
  weighted_metrics = NULL,
  optimizer = "adam",
  early_stopping = FALSE,
  min_delta = 0,
  patience = 0L,
  verbose = 0L,
  baseline = NULL,
  restore_best_weights = FALSE,
  batch_size = 32L,
  epochs = 10L,
  validation_split = 0,
  shuffle = TRUE,
  sample_weight = NULL,
  initial_epoch = 0L,
  steps_per_epoch = NULL,
  validation_steps = NULL,
  ...
)
}
\arguments{
\item{formula}{\code{(formula(1))}\cr
Object specifying the model fit, left-hand-side of formula should describe a \code{\link[survival:Surv]{survival::Surv()}}
object.}

\item{data}{\code{(data.frame(1))}\cr
Training data of \code{data.frame} like object, internally is coerced with \code{\link[stats:model.matrix]{stats::model.matrix()}}.}

\item{reverse}{\code{(logical(1))}\cr
If \code{TRUE} fits estimator on censoring distribution, otherwise (default) survival distribution.}

\item{time_variable}{\code{(character(1))}\cr
Alternative method to call the function. Name of the 'time' variable, required if \code{formula}.
or \code{x} and \code{Y} not given.}

\item{status_variable}{\code{(character(1))}\cr
Alternative method to call the function. Name of the 'status' variable, required if \code{formula}
or \code{x} and \code{Y} not given.}

\item{x}{\code{(data.frame(1))}\cr
Alternative method to call the function. Required if \verb{formula, time_variable} and
\code{status_variable} not given. Data frame like object of features which is internally
coerced with \code{model.matrix}.}

\item{y}{\verb{([survival::Surv()])}\cr
Alternative method to call the function. Required if \verb{formula, time_variable} and
\code{status_variable} not given. Survival outcome of right-censored observations.}

\item{cutpoints}{\code{(numeric())}\cr
Points at which to cut survival time into discrete points.}

\item{cuts}{\code{(integer(1))}\cr
If \code{cutpoints} not provided then number of equally spaced points at which to cut survival time.}

\item{custom_model}{\code{(keras.engine.training.Model(1))} \cr
Optional custom architecture built with \link{build_keras_net} or directly with \CRANpkg{keras}.
Output layer should be of length \code{1} input is number of features plus number of cuts.}

\item{loss_weights, weighted_metrics}{See \link[keras:compile.keras.engine.training.Model]{keras::compile.keras.engine.training.Model}.}

\item{optimizer}{\code{(character(1))}\cr
See \link{get_keras_optimizer}.}

\item{early_stopping}{\code{(logical(1))}\cr
If \code{TRUE} then early stopping callback is included.}

\item{min_delta, patience, baseline, restore_best_weights}{See \link[keras:callback_early_stopping]{keras::callback_early_stopping}.}

\item{verbose}{\code{(integer(1))} \cr
Level of verbosity for printing, \code{0} or \code{1}.}

\item{batch_size, epochs, validation_split, shuffle, sample_weight, initial_epoch, steps_per_epoch, validation_steps}{See \link[keras:fit.keras.engine.training.Model]{keras::fit.keras.engine.training.Model}. # nolint}

\item{...}{\code{ANY} \cr
Passed to \link{get_keras_optimizer}.}
}
\value{
An object of class \code{survivalmodel}.
}
\description{
DNNSurv neural fits a neural network based on pseudo-conditional survival
probabilities.
}
\details{
Code for generating the conditional probabilities and pre-processing data is taken from
\url{https://github.com/lilizhaoUM/DNNSurv}.
}
\examples{
\donttest{
if (requireNamespaces(c("keras", "pseudo")))
  # all defaults
  dnnsurv(data = simsurvdata(10))

  # setting common parameters
  dnnsurv(time_variable = "time", status_variable = "status", data = simsurvdata(10),
          early_stopping = TRUE, epochs = 100L, validation_split = 0.3)
}

}
\references{
Zhao, L., & Feng, D. (2020).
DNNSurv: Deep Neural Networks for Survival Analysis Using Pseudo Values.
https://arxiv.org/abs/1908.02337
}
